/*
 * Decompiled with CFR 0.152.
 */
package net.sqf.xmlUtils.staxParser;

import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.Location;
import net.sqf.xmlUtils.staxParser.ElementInfo;
import net.sqf.xmlUtils.staxParser.NodeInfo;
import net.sqf.xmlUtils.staxParser.PositionalXMLReader;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class AttributeInfo
extends NodeInfo {
    private final Location start;
    private final Location end;
    private final Pattern attrPattern = Pattern.compile("\\s+(\\S+?)(\\s+)?=(\\s+)?(\"([^\"]*)\"|'([^']*)')");

    protected AttributeInfo(Attr node) {
        super(node);
        ElementInfo parentInfo = PositionalXMLReader.getNodeInfo(node.getOwnerElement());
        String attributeRegion = parentInfo.getAttributRegion();
        Location[] startEnd = this.getAttributStartEnd(attributeRegion, parentInfo.getAttributRegionStart(), node);
        this.start = startEnd[0];
        this.end = startEnd[1];
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public Location getStart() {
        return this.start;
    }

    @Override
    public int getStartOffset() {
        return this.start.getCharacterOffset();
    }

    @Override
    public Location getEnd() {
        return this.end;
    }

    @Override
    public int getEndOffset() {
        return this.end.getCharacterOffset();
    }

    private Location[] getAttributStartEnd(String attributRegion, Location locStart, Node attr) {
        Location[] startEnd = new Location[2];
        Matcher matcher = this.attrPattern.matcher(attributRegion);
        while (matcher.find()) {
            String name = matcher.group(1);
            if (!name.equals(attr.getNodeName())) continue;
            MatchResult mresult = matcher.toMatchResult();
            int startPos = mresult.start();
            int endPos = mresult.end();
            startEnd[0] = NodeInfo.newLocation(locStart, startPos);
            startEnd[1] = NodeInfo.newLocation(locStart, endPos);
            break;
        }
        return startEnd;
    }
}

