/*
 * Decompiled with CFR 0.152.
 */
package net.sqf.xmlUtils.parser;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sqf.stringUtils.StringUtil;
import net.sqf.stringUtils.TextSource;
import net.sqf.xmlUtils.parser.PositionalXMLHandler;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class PositionalXMLReader {
    public static final String LINE_NUMBER_KEY_NAME = "lineNumber";
    public static final String COLUMN_NUMBER_KEY_NAME = "columnNumber";
    public static final String LINE_NUMBER_LAST_KEY_NAME = "lineNumberLast";
    public static final String COLUMN_NUMBER_LAST_KEY_NAME = "columnNumberLast";
    public static final String INNER_LINE_NUMBER_KEY_NAME = "innerLineNumber";
    public static final String INNER_COLUMN_NUMBER_KEY_NAME = "innerColumnNumber";
    public static final String INNER_LINE_NUMBER_LAST_KEY_NAME = "innerLineNumberLast";
    public static final String INNER_COLUMN_NUMBER_LAST_KEY_NAME = "innerColumnNumberLast";
    public static final String POSITION_KEY_NAME = "positionStart";
    public static final String INNER_POSITION_KEY_NAME = "positionInner";
    public static final String INNER_POSITION_LAST_KEY_NAME = "positionInnerLast";
    public static final String POSITION_LAST_KEY_NAME = "positionEnd";
    public static final String ATTRIBUTE_REGION_POSITION = "attributeRegionStart";
    public static final String ATTRIBUTE_REGION_POSITION_LAST = "attributeRegionEnd";
    public static final String DTD_POSITION_KEY_NAME = "dtdPositionStart";
    public static final String DTD_POSITION_LAST_KEY_NAME = "dtdPositionEnd";
    public static final String DTD_LINE_NUMMBER_KEY_NAME = "dtdLineNumber";
    public static final String DTD_COLUMN_NUMMBER_KEY_NAME = "dtdColumnNumber";
    public static final String DTD_LINE_NUMMBER_LAST_KEY_NAME = "dtdLineNumberLast";
    public static final String DTD_COLUMN_NUMMBER_LAST_KEY_NAME = "dtdColumnNumberLast";
    public static final int STANDARD_TYPE = 0;
    public static final int ELEMENT_START_TYPE = 1;
    public static final int ELEMENT_END_TYPE = 2;
    public static final int ATTRIBUTE_TYPE = 3;
    public static final int TEXT_TYPE = 4;
    public static final int DTD_TYPE = 5;
    public static final int DTD_TYPE_END = 6;
    protected static final String ELEMENT_ID = "elementId";
    public static final String HAS_DTD = "hasDTD";
    public static final String PREFIX_MAPPING = "prefixMapping";
    public static final String NAMESPACE_MAPPING = "namespaceMapping";
    private final HashMap<Integer, Integer> linePositionMap = new HashMap();
    private int lineCounter = 0;
    private static final XMLReader parser = PositionalXMLReader.initialParser();

    private static XMLReader initialParser() {
        try {
            return XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void positionMap(String doc) {
        String[] lines = StringUtil.getLinesArr(doc);
        int position = 0;
        int lineCount = 0;
        while (lineCount < lines.length) {
            this.linePositionMap.put(lineCount + 1, position);
            String line = lines[lineCount];
            position += line.length();
            ++lineCount;
        }
        this.lineCounter = lineCount;
    }

    public int getLineForPos(int pos) {
        int line = 0;
        while (line < this.lineCounter) {
            int linePos = this.linePositionMap.get(line + 1);
            if (!this.linePositionMap.containsKey(line + 2)) break;
            int lineNextPos = this.linePositionMap.get(line + 2);
            if (linePos <= pos && lineNextPos > pos) break;
            ++line;
        }
        return line;
    }

    public Document readXML(File doc) throws IOException, SAXException {
        TextSource ts = TextSource.readTextFile(doc);
        return this.readXML(ts.toString(), doc.getAbsolutePath());
    }

    public Document readXML(String docString, String baseUri) throws IOException, SAXException {
        Document docNode;
        this.positionMap(docString);
        ByteArrayInputStream is = new ByteArrayInputStream(docString.getBytes());
        ArrayList allNodes = new ArrayList();
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            docNode = docBuilder.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Can't create SAX parser / DOM builder.", e);
        }
        PositionalXMLHandler posHandler = new PositionalXMLHandler(docNode, docString, this.linePositionMap);
        InputStreamReader reader = new InputStreamReader((InputStream)is, "UTF-8");
        InputSource isource = new InputSource(reader);
        isource.setEncoding("UTF-8");
        isource.setSystemId(baseUri);
        parser.setProperty("http://xml.org/sax/properties/lexical-handler", posHandler);
        parser.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        parser.setEntityResolver(posHandler);
        parser.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException arg0) throws SAXException {
            }

            @Override
            public void fatalError(SAXParseException arg0) throws SAXException {
            }

            @Override
            public void error(SAXParseException arg0) throws SAXException {
            }
        });
        parser.setContentHandler(posHandler);
        parser.parse(isource);
        docNode.setUserData("allNodes", allNodes, null);
        docNode.setUserData("positionNodeMap", posHandler.positionNodeMap(), null);
        return docNode;
    }
}

