/*
 * Decompiled with CFR 0.152.
 */
package net.sqf.xmlUtils.exceptions;

import org.xml.sax.SAXParseException;

public class ValidationException
extends Exception {
    public static final String TYPE_SCHEMA = "XSD";
    public static final String TYPE_SCHEMATRON = "SCH";
    public static final String TYPE_OTHER = "OTHER";
    private final String systemId;
    private final int lineNumber;
    private final int colNumber;
    private final String type;

    public ValidationException(Exception e) {
        this(e.getMessage(), "", -1, -1, TYPE_OTHER);
    }

    public ValidationException(Exception e, String systemId) {
        this(e, systemId, -1, -1);
    }

    public ValidationException(Exception e, String systemId, int lineNumber, int colNumber) {
        this(e.getMessage(), systemId, lineNumber, colNumber, TYPE_OTHER);
    }

    public ValidationException(SAXParseException ex, String systemId) {
        this(ex.getMessage(), ex.getSystemId() == null ? systemId : ex.getSystemId(), ex.getLineNumber(), ex.getColumnNumber(), TYPE_SCHEMA);
    }

    public ValidationException(SAXParseException ex) {
        this(ex.getMessage(), ex.getSystemId(), ex.getLineNumber(), ex.getColumnNumber(), TYPE_SCHEMA);
    }

    public ValidationException(String message, String systemId, int lineNumber, int colNumber, String type) {
        super(message);
        this.systemId = systemId;
        this.lineNumber = lineNumber;
        this.colNumber = colNumber;
        this.type = type;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColNumber() {
        return this.colNumber;
    }

    @Override
    public String getLocalizedMessage() {
        return "systemId: " + this.getSystemId() + "; lineNumber: " + this.getLineNumber() + "; columnNumber: " + this.getColNumber() + "; " + super.getLocalizedMessage();
    }
}

