<?xml version="1.0" encoding="UTF-8"?>
<schema xmlns="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2" xmlns:es="http://www.escali.schematron-quickfix.com/" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <es:default-namespace uri="http://www.w3.org/1999/xhtml"/>
    <ns uri="http://www.w3.org/1999/xhtml" prefix="html"/>
    <pattern>
        <rule context="body">
            <let name="firstDescendantHeading" value="descendant::node()[name()=('h1','h2','h3','h4','h5','h6')][1]"/>
            <assert test="$firstDescendantHeading/self::h1">The first headline of a HTML document has to be of level 1.</assert>
        </rule>
        <rule context="h3">
            <let name="firstPrecedingHeading" value="preceding::node()[name()=('h1','h2','h3','h4','h5','h6')][1]"/>
            <report test="$firstPrecedingHeading/self::h1">A headline is missing on level 2: A &lt;h3&gt; should not follow a &lt;<name path="$firstPrecedingHeading"/>&gt;.</report>
        </rule>
        <rule context="h4">
            <let name="firstPrecedingHeading" value="preceding::node()[name()=('h1','h2','h3','h4','h5','h6')][1]"/>
            <report test="$firstPrecedingHeading/self::h1">The headlines on level 2 and 3 are missing: A &lt;h4&gt; should not follow a &lt;<name path="$firstPrecedingHeading"/>&gt;.</report>
            <report test="$firstPrecedingHeading/self::h2">The headline on level 3 is missing: A &lt;h4&gt; should not follow a &lt;<name path="$firstPrecedingHeading"/>&gt;.</report>
        </rule>
    </pattern>
</schema>
