/*
 * Decompiled with CFR 0.152.
 */
package net.sqf.xsm;

import java.io.File;
import java.io.IOException;
import net.sqf.stringUtils.TextSource;
import net.sqf.xsm.CmdProps;
import net.sqf.xsm.operations.PositionalReplace;

public class ManipulatorMain {
    private static final String VERSION = "0.1";
    public static File baseFolder = new File(ManipulatorMain.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getParentFile();

    private static void printHelp() {
        System.out.println("XPath based string manipulator 0.1 from Nico Kutscherauer\nhttp://www.schematron-quickfix.com/scripts/xsm.html\n");
        try {
            System.out.println(CmdProps.getHelpText());
        }
        catch (IOException e) {
            System.out.println("No help text available!");
        }
    }

    public static void main(String[] args) {
        try {
            CmdProps props = new CmdProps(args);
            if (props.isFunctionSetted('s')) {
                PositionalReplace pr;
                File sheet = props.getSheet();
                if (props.isFunctionSetted('i')) {
                    File input = props.getInput();
                    pr = new PositionalReplace(sheet, input);
                } else {
                    pr = new PositionalReplace(sheet, true);
                }
                if (props.isFunctionSetted('o')) {
                    File result = props.getOutput().getAbsoluteFile();
                    result.getParentFile().mkdirs();
                    TextSource.write(result, pr.getSource());
                } else {
                    System.out.println(pr.getSource().toString());
                }
            } else {
                ManipulatorMain.printHelp();
            }
        }
        catch (Exception e) {
            System.err.println("Process canceled by Exception " + e.getClass().getName() + ":");
            System.err.println(String.valueOf(e.getMessage()) + "\n\n");
        }
    }
}

