/*
 * Decompiled with CFR 0.152.
 */
package net.sqf.xmlUtils.staxParser;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sqf.xmlUtils.staxParser.PositionalXMLReader;
import net.sqf.xmlUtils.xpath.NamespaceContextImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UserDataManager {
    private final Document doc;
    private String docBytes;
    private boolean skipWhitespace = true;

    public UserDataManager(Document doc, String docBytes) {
        this.doc = doc;
        this.docBytes = docBytes;
    }

    void setXmlDeclaration(XMLStreamReader event) throws XMLStreamException {
        Range range = this.getRangeAndNextEvent(event);
        this.doc.setUserData("nls", this.newLocation(range.start, range.start.getCharacterOffset() * -1), null);
        this.doc.setUserData("nls", this.newLocation(range.start, range.start.getCharacterOffset() * -1 + this.docBytes.length()), null);
        if (range.start.getCharacterOffset() == 0) {
            this.doc.setUserData("xdls", range.start, null);
            this.doc.setUserData("xdle", range.end, null);
        }
    }

    void setDTD(XMLStreamReader event) throws XMLStreamException {
        Range range = this.getRangeAndNextEvent(event);
        this.skipWhitespace(range);
        this.doc.setUserData("hasDTD", true, null);
        this.doc.setUserData("dls", range.start, null);
        this.doc.setUserData("dle", range.end, null);
    }

    void setNode(Node node, XMLStreamReader event) throws XMLStreamException {
        this.setNode(node, event, false);
    }

    void setNode(Node node, XMLStreamReader event, boolean textNode) throws XMLStreamException {
        NamespaceContext ns = event.getNamespaceContext();
        Range range = this.getRangeAndNextEvent(event);
        this.skipWhitespace(range);
        node.setUserData("nls", range.start, null);
        node.setUserData("nle", range.end, null);
        node.setUserData("nsc", ns, null);
    }

    void setStartElement(Element element, XMLStreamReader event) throws XMLStreamException {
        NamespaceContextImpl nsc = new NamespaceContextImpl(event);
        Range range = this.getRangeAndNextEvent(event);
        String startTag = this.getString(range);
        element.setUserData("nls", range.start, null);
        element.setUserData("nils", range.end, null);
        element.setUserData("nsc", nsc, null);
        this.setAttribute(element, range.start, startTag);
        this.skipWhitespace = false;
    }

    void setAttribute(Element el, Location start, String startTag) {
        int addStartPos;
        Pattern patternStart = Pattern.compile("\\s");
        Matcher matcherStart = patternStart.matcher(startTag);
        Pattern patternEnd = Pattern.compile("(/)?>$", 32);
        Matcher matcherEnd = patternEnd.matcher(startTag);
        int addEndPos = matcherEnd.find() ? matcherEnd.start() : startTag.length() - 1;
        int n = addStartPos = matcherStart.find() ? matcherStart.start() : addEndPos;
        if (addStartPos > 0 && addEndPos > 0) {
            el.setUserData("arls", this.newLocation(start, addStartPos), null);
            el.setUserData("arle", this.newLocation(start, addEndPos), null);
            String attrRegion = startTag.substring(addStartPos, addEndPos);
            el.setUserData("ar", attrRegion, null);
        }
    }

    void setEndElement(Element element, XMLStreamReader event) throws XMLStreamException {
        Node parent = element.getParentNode();
        boolean isEmpty = element.getFirstChild() == null;
        Range range = this.getRangeAndNextEvent(event);
        Location startLoc = PositionalXMLReader.getLocation(element, "nls");
        if (isEmpty && startLoc.getCharacterOffset() == range.start.getCharacterOffset()) {
            element.setUserData("nils", range.end, null);
            element.setUserData("nile", range.end, null);
            String startTag = this.getString(new Range(startLoc, range.end));
            this.setAttribute(element, startLoc, startTag);
        } else {
            element.setUserData("nile", range.start, null);
        }
        element.setUserData("nle", range.end, null);
        element.setUserData("nsc", new NamespaceContextImpl(element), null);
        this.skipWhitespace = parent.getNodeType() == 9;
    }

    private String getString(Range range) {
        return this.docBytes.substring(range.start.getCharacterOffset(), range.end.getCharacterOffset());
    }

    private Location newLocation(final Location loc, int addPositon) {
        final int correctLineNumber = loc.getLineNumber();
        final int correctColumnNumber = loc.getColumnNumber();
        final int correctPosition = loc.getCharacterOffset() + addPositon;
        return new Location(){

            @Override
            public String getSystemId() {
                return loc.getSystemId();
            }

            @Override
            public String getPublicId() {
                return loc.getPublicId();
            }

            @Override
            public int getLineNumber() {
                return correctLineNumber;
            }

            @Override
            public int getColumnNumber() {
                return correctColumnNumber;
            }

            @Override
            public int getCharacterOffset() {
                return correctPosition;
            }
        };
    }

    public void appendToTextNodeBundle(Node newTextNode, ArrayList<Node> textBuffer) {
        Node first = textBuffer.get(0);
        Node last = textBuffer.get(textBuffer.size() - 1);
        newTextNode.setUserData("nls", first.getUserData("nls"), null);
        newTextNode.setUserData("nle", last.getUserData("nle"), null);
    }

    private void skipWhitespace(Range range) {
        if (this.skipWhitespace) {
            String passage = this.getString(range);
            int corPosStart = passage.indexOf(60);
            int corPosEnd = passage.lastIndexOf(62) - passage.length() + 1;
            range.start = this.newLocation(range.start, corPosStart);
            range.end = this.newLocation(range.end, corPosEnd);
        }
    }

    private Range getRangeAndNextEvent(XMLStreamReader event) throws XMLStreamException {
        Location start = event.getLocation();
        event.next();
        Location end = event.getLocation();
        Range range = new Range(start, end);
        return range;
    }

    private class Range {
        private Location start;
        private Location end;

        public Range(Location start, Location end) {
            this.start = start;
            this.end = end;
        }
    }
}

