/*
 * Decompiled with CFR 0.152.
 */
package net.sqf.xmlUtils.staxParser;

import javax.xml.stream.Location;
import net.sqf.xmlUtils.staxParser.PositionalXMLReader;
import org.w3c.dom.Node;

public class NodeInfo {
    protected final Node node;
    private final Location start;
    private final Location end;

    protected NodeInfo(Node node) {
        this.node = node;
        this.start = PositionalXMLReader.getLocation(node, "nls");
        this.end = PositionalXMLReader.getLocation(node, "nle");
    }

    public Node getNode() {
        return this.node;
    }

    public Location getStart() {
        return this.start;
    }

    public int getStartOffset() {
        return this.start.getCharacterOffset();
    }

    public Location getEnd() {
        return this.end;
    }

    public int getEndOffset() {
        return this.end.getCharacterOffset();
    }

    public int getLength() {
        return this.getEndOffset() - this.getStartOffset();
    }

    public Location getMarkStartLocation() {
        return this.getStart();
    }

    public Location getMarkEndLocation() {
        return this.getEnd();
    }

    public int getMarkStart() {
        return this.getStartOffset();
    }

    public int getMarkEnd() {
        return this.getEndOffset();
    }

    public String toString() {
        return String.valueOf(this.node.toString()) + ": [start:" + this.getStartOffset() + "; end:" + this.getEndOffset() + "]";
    }

    protected static Location newLocation(final Location loc, int addPositon) {
        final int correctLineNumber = loc.getLineNumber();
        final int correctColumnNumber = loc.getColumnNumber();
        final int correctPosition = loc.getCharacterOffset() + addPositon;
        return new Location(){

            @Override
            public String getSystemId() {
                return loc.getSystemId();
            }

            @Override
            public String getPublicId() {
                return loc.getPublicId();
            }

            @Override
            public int getLineNumber() {
                return correctLineNumber;
            }

            @Override
            public int getColumnNumber() {
                return correctColumnNumber;
            }

            @Override
            public int getCharacterOffset() {
                return correctPosition;
            }
        };
    }
}

