/*
 * Decompiled with CFR 0.152.
 */
package net.sqf.xmlUtils.exceptions;

import java.util.ArrayList;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;

public class XSLTErrorListener
extends Exception
implements ErrorListener {
    private static final long serialVersionUID = -5657828660296028068L;
    public static final int LEVEL_WARNING = 0;
    public static final int LEVEL_ERROR = 1;
    public static final int LEVEL_FATAL = 2;
    private ArrayList<TransformError> allErros = new ArrayList();
    private ArrayList<TransformerException> warnings = new ArrayList();
    private ArrayList<TransformerException> errors = new ArrayList();
    private ArrayList<TransformerException> fatalErrors = new ArrayList();

    private void addError(TransformError err) {
        this.allErros.add(err);
        switch (err.level) {
            case 0: {
                this.warnings.add(err.exception);
                break;
            }
            case 1: {
                this.errors.add(err.exception);
                break;
            }
            case 2: {
                this.fatalErrors.add(err.exception);
                break;
            }
        }
    }

    @Override
    public void warning(TransformerException warning) throws TransformerException {
        this.addError(new TransformError(warning, 0));
    }

    @Override
    public void fatalError(TransformerException fatal) throws TransformerException {
        this.addError(new TransformError(fatal, 2));
    }

    @Override
    public void error(TransformerException error) throws TransformerException {
        this.addError(new TransformError(error, 1));
    }

    @Override
    public String getLocalizedMessage() {
        String message = "";
        for (TransformError exc : this.allErros) {
            message = String.valueOf(message) + exc.exception.getLocalizedMessage() + "\n";
        }
        return message;
    }

    @Override
    public String getMessage() {
        String message = "";
        for (TransformError exc : this.allErros) {
            message = String.valueOf(message) + exc.exception.getMessage() + "\n";
        }
        return message;
    }

    public boolean hasWarnings() {
        return this.warnings.size() > 0;
    }

    public boolean hasNormalErrors() {
        return this.errors.size() > 0;
    }

    public boolean hasFatalErrors() {
        return this.fatalErrors.size() > 0;
    }

    public boolean hasErrors() {
        return this.hasWarnings() || this.hasNormalErrors() || this.hasFatalErrors();
    }

    public ArrayList<TransformerException> getErrors(int level) {
        ArrayList<TransformerException> errorList = new ArrayList<TransformerException>();
        for (TransformError error : this.allErros) {
            if (error.level < level) continue;
            errorList.add(error.exception);
        }
        return errorList;
    }

    public void copyErrors(XSLTErrorListener copy) {
        for (TransformError error : copy.allErros) {
            this.addError(error);
        }
    }

    public void clear() {
        this.allErros = new ArrayList();
        this.warnings = new ArrayList();
        this.errors = new ArrayList();
        this.fatalErrors = new ArrayList();
    }

    private class TransformError {
        private final TransformerException exception;
        private final int level;

        public TransformError(TransformerException exception, int level) {
            this.exception = exception;
            this.level = level;
        }
    }
}

