/*
 * Decompiled with CFR 0.152.
 */
package net.sqf.utils.process.log;

import java.util.ArrayList;
import java.util.Date;
import net.sqf.utils.process.log.DefaultProcessLoger;
import net.sqf.utils.process.log.ProcessLoger;

public class TimeLoger
extends DefaultProcessLoger
implements ProcessLoger {
    private final ArrayList<Log> logs = new ArrayList();
    private final Date startTime = new Date();

    @Override
    public void log(String message) {
        this.logs.add(new Log(message));
    }

    @Override
    public void log(String message, boolean taskEnd) {
        this.log(message);
    }

    public String toString() {
        String s = "";
        int i = 0;
        for (Log l : this.logs) {
            s = String.valueOf(s) + l.d + " (" + this.getDiffInSec(i) + "s) : " + l.m + "\n";
            ++i;
        }
        return s;
    }

    private long getDiff(int step) {
        if (step < 0 || step >= this.logs.size()) {
            return 0L;
        }
        Date start = step == 0 ? this.startTime : this.logs.get((int)(step - 1)).d;
        Date end = this.logs.get((int)step).d;
        return end.getTime() - start.getTime();
    }

    public long getDiff() {
        int step = this.logs.size() - 1;
        return this.logs.get((int)step).d.getTime() - this.startTime.getTime();
    }

    public double getDiffInSec(int step) {
        return (double)this.getDiff(step) / 1000.0;
    }

    public double getDiffInSec() {
        return (double)this.getDiff() / 1000.0;
    }

    private class Log {
        final Date d = new Date();
        final String m;

        public Log(String message) {
            this.m = message;
        }
    }
}

