/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import org.apache.http.impl.client.SystemDefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class ResourceConnection {
    private InputStream stream = null;
    private String absuri = null;
    private String redirect = null;
    private int statusCode = -1;
    private String contentType = null;
    private String etag = null;

    public ResourceConnection(String resolved) {
        try {
            URI uri = new URI(resolved);
            URL url = uri.toURL();
            this.absuri = url.toString();
            if (this.absuri.startsWith("http:") || this.absuri.startsWith("https:")) {
                SystemDefaultHttpClient client = new SystemDefaultHttpClient();
                client.setHttpRequestRetryHandler((HttpRequestRetryHandler)new StandardHttpRequestRetryHandler(3, false));
                BasicHttpParams params = new BasicHttpParams();
                BasicHttpContext localContext = new BasicHttpContext();
                HttpGet httpRequest = new HttpGet(this.absuri);
                httpRequest.setParams((HttpParams)params);
                HttpResponse httpResponse = client.execute((HttpUriRequest)httpRequest, (HttpContext)localContext);
                this.statusCode = httpResponse.getStatusLine().getStatusCode();
                this.contentType = this.getHeader(httpResponse, "Content-Type", "application/octet-stream");
                this.etag = this.getHeader(httpResponse, "Etag", null);
                if (this.statusCode == 200) {
                    this.stream = httpResponse.getEntity().getContent();
                    HttpHost host = (HttpHost)localContext.getAttribute("http.target_host");
                    HttpUriRequest req = (HttpUriRequest)localContext.getAttribute("http.request");
                    String string = this.redirect = req.getURI().isAbsolute() ? req.getURI().toString() : host.toURI() + req.getURI();
                    if (this.absuri.equals(this.redirect)) {
                        this.redirect = null;
                    }
                }
            } else {
                URLConnection connection = url.openConnection();
                connection.connect();
                this.stream = connection.getInputStream();
                this.contentType = null;
                this.etag = connection.getHeaderField("etag");
                this.statusCode = 200;
            }
        }
        catch (URISyntaxException use) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public InputStream getStream() {
        return this.stream;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getEtag() {
        return this.etag;
    }

    public String getURI() {
        return this.absuri;
    }

    public String getRedirect() {
        return this.redirect;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    private String getHeader(HttpResponse resp, String name, String def) {
        Header[] headers = resp.getHeaders(name);
        if (headers == null) {
            return def;
        }
        if (headers == null || headers.length == 0) {
            return def;
        }
        return headers[0].getValue();
    }
}

