/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.saxtree;

import nu.validator.saxtree.LocatorImpl;
import nu.validator.saxtree.Node;
import org.xml.sax.Locator;

public abstract class ParentNode
extends Node {
    protected Locator endLocator;
    private Node firstChild = null;
    private Node lastChild = null;

    ParentNode(Locator locator) {
        super(locator);
    }

    public void setEndLocator(Locator endLocator) {
        this.endLocator = new LocatorImpl(endLocator);
    }

    public void copyEndLocator(ParentNode another) {
        this.endLocator = another.endLocator;
    }

    @Override
    public final Node getFirstChild() {
        return this.firstChild;
    }

    public final Node getLastChild() {
        return this.lastChild;
    }

    public Node insertBefore(Node child, Node sibling) {
        assert (sibling == null || this == sibling.getParentNode());
        if (sibling == null) {
            return this.appendChild(child);
        }
        child.detach();
        child.setParentNode(this);
        if (this.firstChild == sibling) {
            child.setNextSibling(sibling);
            this.firstChild = child;
        } else {
            Node prev = this.firstChild;
            Node next = this.firstChild.getNextSibling();
            while (next != sibling) {
                prev = next;
                next = next.getNextSibling();
            }
            prev.setNextSibling(child);
            child.setNextSibling(next);
        }
        return child;
    }

    public Node insertBetween(Node child, Node prev, Node next) {
        assert (prev == null || this == prev.getParentNode());
        assert (next == null || this == next.getParentNode());
        assert (prev != null || next == this.firstChild);
        assert (next != null || prev == this.lastChild);
        assert (prev == null || next == null || prev.getNextSibling() == next);
        if (next == null) {
            return this.appendChild(child);
        }
        child.detach();
        child.setParentNode(this);
        child.setNextSibling(next);
        if (prev == null) {
            this.firstChild = child;
        } else {
            prev.setNextSibling(child);
        }
        return child;
    }

    public Node appendChild(Node child) {
        child.detach();
        child.setParentNode(this);
        if (this.firstChild == null) {
            this.firstChild = child;
        } else {
            this.lastChild.setNextSibling(child);
        }
        this.lastChild = child;
        return child;
    }

    public void appendChildren(Node parent) {
        Node child = parent.getFirstChild();
        if (child == null) {
            return;
        }
        ParentNode another = (ParentNode)parent;
        if (this.firstChild == null) {
            this.firstChild = child;
        } else {
            this.lastChild.setNextSibling(child);
        }
        this.lastChild = another.lastChild;
        do {
            child.setParentNode(this);
        } while ((child = child.getNextSibling()) != null);
        another.firstChild = null;
        another.lastChild = null;
    }

    void removeChild(Node node) {
        assert (this == node.getParentNode());
        if (this.firstChild == node) {
            this.firstChild = node.getNextSibling();
            if (this.lastChild == node) {
                this.lastChild = null;
            }
        } else {
            Node prev = this.firstChild;
            Node next = this.firstChild.getNextSibling();
            while (next != node) {
                prev = next;
                next = next.getNextSibling();
            }
            prev.setNextSibling(node.getNextSibling());
            if (this.lastChild == node) {
                this.lastChild = prev;
            }
        }
    }
}

