/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.test;

import java.io.IOException;
import java.io.InputStream;

public class UntilHashInputStream
extends InputStream {
    private final StringBuilder builder = new StringBuilder();
    private final InputStream delegate;
    private int buffer = -1;
    private boolean closed = false;

    public UntilHashInputStream(InputStream delegate) throws IOException {
        this.delegate = delegate;
        this.buffer = delegate.read();
        if (this.buffer == 35) {
            this.closed = true;
        }
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            return -1;
        }
        int rv = this.buffer;
        this.buffer = this.delegate.read();
        if (this.buffer == 35 && rv == 10) {
            this.closed = true;
            return -1;
        }
        if (rv >= 32 && rv < 128) {
            this.builder.append((char)rv);
        } else {
            this.builder.append("0x");
            this.builder.append(Integer.toHexString(rv));
        }
        return rv;
    }

    @Override
    public void close() throws IOException {
        int b;
        super.close();
        if (this.closed) {
            return;
        }
        while ((b = this.delegate.read()) != 35 && b != -1) {
        }
        this.closed = true;
    }

    public String toString() {
        return this.builder.toString();
    }
}

