/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.test;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.LinkedList;
import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.sax.HtmlParser;
import nu.validator.htmlparser.test.ListErrorHandler;
import nu.validator.htmlparser.test.TreeDumpContentHandler;
import nu.validator.htmlparser.test.UntilHashInputStream;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class TreeTester {
    private final BufferedInputStream aggregateStream;
    private boolean streaming = false;

    public TreeTester(InputStream aggregateStream) {
        this.aggregateStream = new BufferedInputStream(aggregateStream);
    }

    private void runTests() throws Throwable {
        if (this.aggregateStream.read() != 35) {
            System.err.println("No hash at start!");
            return;
        }
        while (this.runTest()) {
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean runTest() throws Throwable {
        UntilHashInputStream stream = null;
        try {
            int ch;
            int c;
            String context = null;
            this.aggregateStream.mark(12288);
            if (this.skipLabel()) {
                return false;
            }
            stream = new UntilHashInputStream(this.aggregateStream);
            while (stream.read() != -1) {
            }
            if (this.skipLabel()) {
                System.err.println("Premature end of test data.");
                return false;
            }
            stream = new UntilHashInputStream(this.aggregateStream);
            while (stream.read() != -1) {
            }
            StringBuilder sb = new StringBuilder();
            while ((c = this.aggregateStream.read()) != 10) {
                sb.append((char)c);
            }
            String label = sb.toString();
            if ("document-fragment".equals(label)) {
                sb.setLength(0);
                while ((c = this.aggregateStream.read()) != 10) {
                    sb.append((char)c);
                }
                context = sb.toString();
            }
            this.aggregateStream.reset();
            if (this.skipLabel()) {
                System.err.println("Premature end of test data.");
                return false;
            }
            stream = new UntilHashInputStream(this.aggregateStream);
            InputSource is = new InputSource(stream);
            is.setEncoding("UTF-8");
            StringWriter sw = new StringWriter();
            ListErrorHandler leh = new ListErrorHandler();
            TreeDumpContentHandler treeDumpContentHandler = new TreeDumpContentHandler(sw);
            HtmlParser htmlParser = new HtmlParser(XmlViolationPolicy.ALLOW);
            if (this.streaming) {
                htmlParser.setStreamabilityViolationPolicy(XmlViolationPolicy.FATAL);
            }
            htmlParser.setContentHandler(treeDumpContentHandler);
            htmlParser.setLexicalHandler(treeDumpContentHandler);
            htmlParser.setErrorHandler(leh);
            htmlParser.setScriptingEnabled(true);
            try {
                if (context == null) {
                    htmlParser.parse(is);
                } else {
                    htmlParser.parseFragment(is, context);
                    treeDumpContentHandler.endDocument();
                }
            }
            catch (SAXParseException sAXParseException) {
                // empty catch block
            }
            stream.close();
            if (this.skipLabel()) {
                System.err.println("Premature end of test data.");
                return false;
            }
            LinkedList<String> expectedErrors = new LinkedList<String>();
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new UntilHashInputStream(this.aggregateStream), "UTF-8"));
            String line = null;
            while ((line = br.readLine()) != null) {
                expectedErrors.add(line);
            }
            if (context != null) {
                if (this.skipLabel()) {
                    System.err.println("Premature end of test data.");
                    return false;
                }
                UntilHashInputStream stream2 = new UntilHashInputStream(this.aggregateStream);
                while (stream2.read() != -1) {
                }
            }
            if (this.skipLabel()) {
                System.err.println("Premature end of test data.");
                return false;
            }
            StringBuilder expectedBuilder = new StringBuilder();
            br = new BufferedReader(new InputStreamReader((InputStream)new UntilHashInputStream(this.aggregateStream), "UTF-8"));
            while ((ch = br.read()) != -1) {
                expectedBuilder.append((char)ch);
            }
            String expected = expectedBuilder.toString();
            String actual = sw.toString();
            LinkedList<String> actualErrors = leh.getErrors();
            if (expected.equals(actual) || this.streaming && leh.isFatal()) {
                System.err.println("Success.");
                return true;
            }
            System.err.print("Failure.\nData:\n" + stream + "\nExpected:\n" + expected + "Got: \n" + actual);
            System.err.println("Expected errors:");
            for (String err : expectedErrors) {
                System.err.println(err);
            }
            System.err.println("Actual errors:");
            for (String err : actualErrors) {
                System.err.println(err);
            }
            return true;
        }
        catch (Throwable t) {
            System.err.println("Failure.\nData:\n" + stream);
            throw t;
        }
    }

    private boolean skipLabel() throws IOException {
        int b = this.aggregateStream.read();
        if (b == -1) {
            return true;
        }
        do {
            if ((b = this.aggregateStream.read()) != -1) continue;
            return true;
        } while (b != 10);
        return false;
    }

    public static void main(String[] args) throws Throwable {
        int i = 0;
        while (i < args.length) {
            TreeTester tester = new TreeTester(new FileInputStream(args[i]));
            tester.runTests();
            ++i;
        }
    }
}

