/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.UntypedAtomicValue;

public final class UntypedSequenceConverter
extends AtomicSequenceConverter {
    public UntypedSequenceConverter(Expression sequence, PlainType requiredItemType) {
        super(sequence, requiredItemType);
    }

    public static UntypedSequenceConverter makeUntypedSequenceConverter(Configuration config, Expression operand, PlainType requiredItemType) throws XPathException {
        TypeHierarchy th = config.getTypeHierarchy();
        UntypedSequenceConverter atomicSeqConverter = new UntypedSequenceConverter(operand, requiredItemType);
        ConversionRules rules = config.getConversionRules();
        if (((SimpleType)((Object)requiredItemType)).isNamespaceSensitive()) {
            throw new XPathException("Cannot convert untyped atomic values to a namespace-sensitive type", "XPTY0117");
        }
        Converter untypedConverter = requiredItemType.isAtomicType() ? rules.getConverter(BuiltInAtomicType.UNTYPED_ATOMIC, (AtomicType)requiredItemType) : new StringConverter.StringToUnionConverter(requiredItemType, rules);
        UntypedConverter converter = new UntypedConverter(rules, untypedConverter);
        atomicSeqConverter.setConverter(converter);
        return atomicSeqConverter;
    }

    public static UntypedSequenceConverter makeUntypedSequenceRejector(Configuration config, final Expression operand, final PlainType requiredItemType) {
        UntypedSequenceConverter atomicSeqConverter = new UntypedSequenceConverter(operand, requiredItemType);
        ConversionRules rules = config.getConversionRules();
        Converter untypedConverter = new Converter(){

            public ConversionResult convert(AtomicValue input) {
                ValidationFailure vf = new ValidationFailure("Implicit conversion of untypedAtomic value to " + requiredItemType.toString() + " is not allowed");
                vf.setErrorCode("XPTY0117");
                vf.setLocator(operand);
                return vf;
            }
        };
        UntypedConverter converter = new UntypedConverter(rules, untypedConverter);
        atomicSeqConverter.setConverter(converter);
        return atomicSeqConverter;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        Expression e2 = super.typeCheck(visitor, contextItemType);
        if (e2 != this) {
            return e2;
        }
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        if (th.relationship(this.operand.getItemType(th), BuiltInAtomicType.UNTYPED_ATOMIC) == 4) {
            return this.operand;
        }
        return this;
    }

    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        return p | 0x400000 | 0x2000000;
    }

    public Expression copy() {
        UntypedSequenceConverter atomicConverter = new UntypedSequenceConverter(this.getBaseExpression().copy(), this.getRequiredItemType());
        atomicConverter.setConverter(this.converter);
        return atomicConverter;
    }

    public ItemType getItemType(TypeHierarchy th) {
        if (this.operand.getItemType(th) == BuiltInAtomicType.UNTYPED_ATOMIC) {
            return this.getRequiredItemType();
        }
        return Type.getCommonSuperType(this.getRequiredItemType(), this.operand.getItemType(th), th);
    }

    public int computeCardinality() {
        return this.operand.getCardinality();
    }

    public boolean equals(Object other) {
        return other instanceof UntypedSequenceConverter && super.equals(other);
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected String displayOperator(Configuration config) {
        return "convertUntyped";
    }

    public String getExpressionName() {
        return "convertUntyped";
    }

    public void explain(ExpressionPresenter destination) {
        destination.startElement("convertUntyped");
        destination.emitAttribute("to", this.getRequiredItemType().toString());
        this.operand.explain(destination);
        destination.endElement();
    }

    public static class UntypedConverter
    extends Converter {
        Converter untypedConverter = null;

        public UntypedConverter(ConversionRules rules, Converter converter) {
            super(rules);
            this.untypedConverter = converter;
        }

        public ConversionResult convert(AtomicValue input) {
            if (input instanceof UntypedAtomicValue) {
                return this.untypedConverter.convert(input);
            }
            return input;
        }
    }
}

