/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.extra;

import com.ibm.icu.text.CharsetDetector;
import java.io.IOException;
import java.nio.charset.UnsupportedCharsetException;
import nu.validator.htmlparser.io.Encoding;
import org.mozilla.intl.chardet.nsDetector;
import org.mozilla.intl.chardet.nsICharsetDetectionObserver;

public class ChardetSniffer
implements nsICharsetDetectionObserver {
    private final byte[] source;
    private final int length;
    private Encoding returnValue = null;

    public ChardetSniffer(byte[] source, int length) {
        this.source = source;
        this.length = length;
    }

    public Encoding sniff() throws IOException {
        nsDetector detector = new nsDetector(0);
        detector.Init((nsICharsetDetectionObserver)this);
        detector.DoIt(this.source, this.length, false);
        detector.DataEnd();
        if (this.returnValue != null && this.returnValue != Encoding.WINDOWS1252 && this.returnValue.isAsciiSuperset()) {
            return this.returnValue;
        }
        return null;
    }

    public static void main(String[] args) {
        String[] detectable = CharsetDetector.getAllDetectableCharsets();
        int i = 0;
        while (i < detectable.length) {
            String charset = detectable[i];
            System.out.println(charset);
            ++i;
        }
    }

    public void Notify(String charsetName) {
        try {
            Encoding enc = Encoding.forName(charsetName);
            Encoding actual = enc.getActualHtmlEncoding();
            if (actual != null) {
                enc = actual;
            }
            this.returnValue = enc;
        }
        catch (UnsupportedCharsetException e) {
            this.returnValue = null;
        }
    }
}

