/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sxpath;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.ConstructorFunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.SystemFunctionLibrary;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.PatternSponsor;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.sxpath.SimpleContainer;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.sxpath.XPathStaticContext;
import net.sf.saxon.sxpath.XPathVariable;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.DecimalValue;

public class XPathEvaluator {
    private XPathStaticContext staticContext;

    public XPathEvaluator() {
        this(new Configuration());
    }

    public XPathEvaluator(Configuration config) {
        this.staticContext = new IndependentContext(config);
    }

    public Configuration getConfiguration() {
        return this.staticContext.getConfiguration();
    }

    public XPathVariable declareVariable(String uri, String localName) {
        return this.staticContext.declareVariable(uri, localName);
    }

    public void setStaticContext(XPathStaticContext context) {
        this.staticContext = context;
    }

    public XPathStaticContext getStaticContext() {
        return this.staticContext;
    }

    public XPathExpression createExpression(String expression) throws XPathException {
        Configuration config = this.getConfiguration();
        Executable exec = new Executable(config);
        SimpleContainer container = new SimpleContainer(exec);
        boolean allowXPath30 = this.staticContext.getXPathLanguageLevel().equals(DecimalValue.THREE);
        exec.setSchemaAware(this.staticContext.isSchemaAware());
        exec.setHostLanguage(54, allowXPath30);
        FunctionLibraryList userlib = exec.getFunctionLibrary();
        FunctionLibraryList lib = new FunctionLibraryList();
        int permittedFunctions = 1;
        if (allowXPath30) {
            permittedFunctions |= 0x10;
        }
        lib.addFunctionLibrary(SystemFunctionLibrary.getSystemFunctionLibrary(permittedFunctions));
        lib.addFunctionLibrary(config.getVendorFunctionLibrary());
        lib.addFunctionLibrary(new ConstructorFunctionLibrary(config));
        lib.addFunctionLibrary(config.getIntegratedFunctionLibrary());
        config.addExtensionBinders(lib);
        if (userlib != null) {
            lib.addFunctionLibrary(userlib);
        }
        exec.setFunctionLibrary(lib);
        Expression exp = ExpressionTool.make(expression, this.staticContext, container, 0, -1, 1, null);
        exp.setContainer(container);
        ExpressionVisitor visitor = ExpressionVisitor.make(this.staticContext, exec);
        visitor.setExecutable(exec);
        ItemType contextItemType = this.staticContext.getRequiredContextItemType();
        ExpressionVisitor.ContextItemType cit = new ExpressionVisitor.ContextItemType(contextItemType, true);
        exp = visitor.typeCheck(exp, cit);
        exp = visitor.optimize(exp, cit);
        exp.setContainer(container);
        SlotManager map = this.staticContext.getStackFrameMap();
        int numberOfExternalVariables = map.getNumberOfVariables();
        ExpressionTool.allocateSlots(exp, numberOfExternalVariables, map);
        XPathExpression xpe = new XPathExpression(this, exp);
        xpe.setStackFrameMap(map, numberOfExternalVariables);
        return xpe;
    }

    public XPathExpression createPattern(String pattern) throws XPathException {
        Executable exec = new Executable(this.getConfiguration());
        Pattern pat = Pattern.make(pattern, this.staticContext, exec);
        ExpressionVisitor visitor = ExpressionVisitor.make(this.staticContext, exec);
        pat.analyze(visitor, new ExpressionVisitor.ContextItemType(Type.NODE_TYPE, true));
        SlotManager map = this.staticContext.getStackFrameMap();
        int slots = map.getNumberOfVariables();
        slots = pat.allocateSlots(map, slots);
        PatternSponsor sponsor = new PatternSponsor(pat);
        XPathExpression xpe = new XPathExpression(this, sponsor);
        xpe.setStackFrameMap(map, slots);
        return xpe;
    }

    public void setNamespaceResolver(NamespaceResolver namespaceResolver) {
        this.staticContext.setNamespaceResolver(namespaceResolver);
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.staticContext.getNamespaceResolver();
    }

    public void setDefaultElementNamespace(String uri) {
        this.staticContext.setDefaultElementNamespace(uri);
    }
}

