/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcException;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class URIUtils {
    protected URIUtils() {
    }

    public static String encode(String src) {
        String genDelims = ":/?#[]@";
        String subDelims = "!$&'()*+,;=";
        String unreserved = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-._~";
        String okChars = String.valueOf(genDelims) + subDelims + unreserved + "%";
        String filesep = System.getProperty("file.separator");
        if ("\\".equals(filesep)) {
            src = src.replaceAll("\\\\", "/");
        }
        String encoded = "";
        try {
            byte[] bytes = src.getBytes("UTF-8");
            int pos = 0;
            while (pos < bytes.length) {
                encoded = okChars.indexOf(bytes[pos]) >= 0 ? String.valueOf(encoded) + (char)bytes[pos] : String.valueOf(encoded) + String.format("%%%02X", bytes[pos]);
                ++pos;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return encoded;
    }

    public static URI homeAsURI() {
        return URIUtils.dirAsURI(System.getProperty("user.home"));
    }

    public static URI cwdAsURI() {
        return URIUtils.dirAsURI(System.getProperty("user.dir"));
    }

    public static URI dirAsURI(String dir) {
        URI cwd = null;
        try {
            String path = URIUtils.encode(dir);
            if (!path.endsWith("/")) {
                path = String.valueOf(path) + "/";
            }
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            cwd = new URI("file:" + path);
        }
        catch (URISyntaxException use) {
            throw new XProcException(use);
        }
        return cwd;
    }

    public static URI makeAbsolute(String localFn) {
        URI cwd = URIUtils.cwdAsURI();
        return cwd.resolve(URIUtils.encode(localFn));
    }

    public static File getFile(String uri) {
        File file;
        URL url;
        try {
            url = new URL(uri);
        }
        catch (MalformedURLException mue) {
            throw new XProcException(mue);
        }
        try {
            file = new File(url.toURI());
        }
        catch (URISyntaxException e) {
            file = new File(url.getPath());
        }
        return file;
    }
}

