/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.model;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.model.Binding;
import com.xmlcalabash.model.DeclareStep;
import com.xmlcalabash.model.EmptyBinding;
import com.xmlcalabash.model.EndPoint;
import com.xmlcalabash.model.Environment;
import com.xmlcalabash.model.ErrorBinding;
import com.xmlcalabash.model.Input;
import com.xmlcalabash.model.Log;
import com.xmlcalabash.model.Option;
import com.xmlcalabash.model.Output;
import com.xmlcalabash.model.Parameter;
import com.xmlcalabash.model.PipeBinding;
import com.xmlcalabash.model.PipeNameBinding;
import com.xmlcalabash.model.Port;
import com.xmlcalabash.model.SourceArtifact;
import com.xmlcalabash.model.Variable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;

public class Step
extends SourceArtifact {
    private static final QName cx_depend = new QName("cx", "http://xmlcalabash.com/ns/extensions", "depend");
    private static final QName cx_depends = new QName("cx", "http://xmlcalabash.com/ns/extensions", "depends");
    private static final QName cx_dependson = new QName("cx", "http://xmlcalabash.com/ns/extensions", "dependson");
    protected QName stepType = null;
    protected String stepName = null;
    private boolean anonymous = false;
    protected Vector<Input> inputs = new Vector();
    protected Vector<Output> outputs = new Vector();
    private Vector<Option> options = new Vector();
    private Vector<Log> logs = new Vector();
    private Vector<Parameter> params = new Vector();
    private HashSet<String> dependsOn = new HashSet();
    protected Environment env = null;
    protected Step parent = null;
    private int depth = -1;
    private boolean ordered = false;
    private static HashSet<String> anonNames = new HashSet();
    Vector<Step> subpipeline = new Vector();
    protected DeclareStep declaration = null;
    protected Double version = null;

    public Step(XProcRuntime xproc, XdmNode node, QName type) {
        super(xproc, node);
        this.stepType = type;
        this.stepName = this.anonymousName(node);
    }

    public Step(XProcRuntime xproc, XdmNode node, QName type, String name) {
        super(xproc, node);
        this.stepType = type;
        this.stepName = name;
        if (this.stepName == null) {
            this.stepName = this.anonymousName(node);
        }
    }

    public boolean isPipeline() {
        return false;
    }

    private synchronized String anonymousName(XdmNode node) {
        String stepName = this.recursiveAnonymousName(node);
        anonNames.add(stepName);
        return stepName;
    }

    private String recursiveAnonymousName(XdmNode node) {
        if (node.getParent().getNodeKind() == XdmNodeKind.DOCUMENT) {
            return "!1";
        }
        XdmSequenceIterator iter = node.axisIterator(Axis.PRECEDING_SIBLING);
        int count = 1;
        while (iter.hasNext()) {
            XdmNode pnode = (XdmNode)iter.next();
            if (pnode.getNodeKind() != XdmNodeKind.ELEMENT) continue;
            ++count;
        }
        return String.valueOf(this.anonymousName(node.getParent())) + "." + count;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public void setDeclaration(DeclareStep decl) {
        this.declaration = decl;
    }

    public DeclareStep getDeclaration() {
        return this.declaration;
    }

    public boolean isPipelineCall() {
        return !this.declaration.isAtomic();
    }

    public QName getType() {
        return this.stepType;
    }

    public Step getStep() {
        return this;
    }

    protected void setVersion(Double version) {
        this.version = version;
    }

    public Double getVersion() {
        if (this.version == null) {
            if (this.parent != null) {
                return this.parent.getVersion();
            }
            throw new UnsupportedOperationException("Step with no version or inherited version!?");
        }
        return this.version;
    }

    public QName getDeclaredType() {
        return this.stepType;
    }

    public String getName() {
        return this.stepName;
    }

    @Override
    public XdmNode getNode() {
        return this.node;
    }

    public Step getPipeline() {
        Step parent = this;
        while (parent != null && parent.stepType != XProcConstants.p_declare_step) {
            parent = parent.parent;
        }
        return parent;
    }

    public boolean containsStep(String stepName) {
        return false;
    }

    public void addStep(Step step) {
        step.parent = this;
        this.subpipeline.add(step);
    }

    public void setSubpipeline(Vector<Step> pipeline) {
        this.subpipeline = pipeline;
    }

    public Vector<Step> subpipeline() {
        return this.subpipeline;
    }

    public void addVariable(Variable variable) {
        throw new UnsupportedOperationException("You can only call addVariable() on a compound step");
    }

    public Collection<Variable> getVariables() {
        return new Vector<Variable>();
    }

    public void addInput(Input input) {
        input.setStep(this);
        for (Input current : this.inputs) {
            if (!current.getPort().equals(input.getPort())) continue;
            throw XProcException.staticError(11, input.getNode(), "Input port name '" + input.getPort() + "' appears more than once.");
        }
        this.inputs.add(input);
    }

    public Vector<Input> inputs() {
        return this.inputs;
    }

    public Input getInput(String portName) {
        for (Input input : this.inputs) {
            if (!portName.equals(input.getPort())) continue;
            return input;
        }
        return null;
    }

    public void addOutput(Output output) {
        output.setStep(this);
        for (Output current : this.outputs) {
            if (!current.getPort().equals(output.getPort())) continue;
            throw XProcException.staticError(11, output.getNode(), "Output port name '" + output.getPort() + "' appears more than once.");
        }
        this.outputs.add(output);
    }

    public Vector<Output> outputs() {
        return this.outputs;
    }

    public Output getPrimaryOutput() {
        int count = 0;
        Output defPrimary = null;
        for (Output output : this.outputs) {
            if ("#current".equals(output.getPort())) continue;
            if (output.getPrimary() || !output.getPrimarySet()) {
                defPrimary = output;
            }
            ++count;
            if (!output.getPrimary()) continue;
            return output;
        }
        if (count == 1) {
            return defPrimary;
        }
        return null;
    }

    public Output getOutput(String portName) {
        for (Output output : this.outputs) {
            if (!portName.equals(output.getPort())) continue;
            return output;
        }
        return null;
    }

    public void addOption(Option option) {
        QName optName = option.getName();
        for (Option exoption : this.options) {
            if (!optName.equals(exoption.getName())) continue;
            this.error(option.getNode(), "Duplication option name: " + optName, XProcConstants.staticError(4));
        }
        this.options.add(option);
    }

    public Vector<Option> options() {
        return this.options;
    }

    public Option getOption(QName name) {
        for (Option option : this.options) {
            if (!name.equals(option.getName())) continue;
            return option;
        }
        return null;
    }

    public List<QName> getOptions() {
        Vector<QName> names = new Vector<QName>();
        for (Option option : this.options) {
            names.add(option.getName());
        }
        return names;
    }

    public void addLog(Log log) {
        this.logs.add(log);
    }

    public Log getLog(String port) {
        for (Log log : this.logs) {
            if (!port.equals(log.getPort())) continue;
            return log;
        }
        return null;
    }

    public void addParameter(Parameter param) {
        this.params.add(param);
    }

    public Parameter getParameter(QName name) {
        for (Parameter param : this.params) {
            if (!name.equals(param.getName())) continue;
            return param;
        }
        return null;
    }

    public List<QName> getParameters() {
        Vector<QName> names = new Vector<QName>();
        for (Parameter param : this.params) {
            names.add(param.getName());
        }
        return names;
    }

    public Vector<Parameter> parameters() {
        return this.params;
    }

    public boolean loops() {
        return false;
    }

    public boolean insideALoop() {
        if (this.parent == null) {
            return false;
        }
        return this.parent.loops() || this.parent.insideALoop();
    }

    public Output getDefaultOutput() {
        int count = 0;
        Port defout = null;
        for (Output output : this.outputs) {
            if (output.getPort().startsWith("#")) continue;
            if (output.getPrimary()) {
                return output;
            }
            if (output.getPort().endsWith("|")) continue;
            ++count;
            defout = output;
        }
        if (count == 1 && (defout.getPrimary() || !defout.getPrimarySet())) {
            return defout;
        }
        return null;
    }

    protected void addDependency(String stepName) {
        this.dependsOn.add(stepName);
    }

    protected HashSet<String> getDependencies() {
        return this.dependsOn;
    }

    protected boolean dependsOn(String stepName) {
        return this.dependsOn.contains(stepName);
    }

    protected boolean matchesDeclaration() {
        boolean valid = true;
        DeclareStep decl = this.declaration;
        if (decl == null) {
            return true;
        }
        Hashtable<String, Input> declInputs = new Hashtable<String, Input>();
        for (Input input : decl.inputs()) {
            declInputs.put(input.getPort(), input);
        }
        for (Input input : this.inputs()) {
            String port = input.getPort();
            if (port.startsWith("|")) continue;
            if (!declInputs.containsKey(port)) {
                if (this.getVersion() != 1.0) continue;
                this.error("Undeclared input port '" + port + "' on " + this, XProcConstants.staticError(10));
                valid = false;
                continue;
            }
            input.setPrimary(((Input)declInputs.get(port)).getPrimary());
        }
        Hashtable<String, Output> declOutputs = new Hashtable<String, Output>();
        for (Output output : decl.outputs()) {
            declOutputs.put(output.getPort(), output);
        }
        for (Output output : this.outputs()) {
            String port = output.getPort();
            if (port.endsWith("|")) continue;
            if (!declOutputs.containsKey(port) && !declOutputs.containsKey("*")) {
                this.error("Undeclared output port: " + port, XProcConstants.staticError(10));
                valid = false;
                continue;
            }
            output.setPrimary(((Output)declOutputs.get(port)).getPrimary());
        }
        return valid;
    }

    protected boolean validOptions() {
        HashSet<Object> names = new HashSet<Object>();
        boolean valid = true;
        for (Option p : this.options) {
            valid = valid && p.valid(this.env);
            QName pName = p.getName();
            if (pName == null) {
                valid = false;
                this.error("Option without name", XProcConstants.staticError(38));
                continue;
            }
            if (names.contains(pName)) {
                valid = false;
                this.error("Duplicate option name: " + pName, XProcConstants.staticError(4));
                continue;
            }
            names.add(pName);
        }
        DeclareStep decl = this.declaration;
        if (decl != null) {
            for (Option doption : decl.options()) {
                if (!doption.getRequired() || this.getOption(doption.getName()) != null) continue;
                valid = false;
                this.error("Required option not specified: " + doption.getName(), XProcConstants.staticError(18));
            }
            Vector<Option> okOpts = new Vector<Option>();
            for (Option option : this.options()) {
                Option doption = decl.getOption(option.getName());
                if (doption == null) {
                    if (this.getVersion() > 1.0) continue;
                    valid = false;
                    this.error("Undeclared option specified: " + option.getName(), XProcConstants.staticError(10));
                    continue;
                }
                okOpts.add(option);
            }
            this.options = okOpts;
        }
        return valid;
    }

    protected boolean validParams() {
        HashSet<QName> names = new HashSet<QName>();
        boolean valid = true;
        for (Parameter p : this.params) {
            Input input2;
            valid = valid && p.valid(this.env);
            QName pName = p.getName();
            if (pName == null) {
                valid = false;
                this.error("Parameter without name", XProcConstants.staticError(38));
            } else if (names.contains(pName)) {
                valid = false;
                this.error("Duplicate parameter name: " + pName, XProcConstants.staticError(4));
            } else {
                names.add(pName);
            }
            String port = p.getPort();
            if (port == null) {
                for (Input input2 : this.inputs()) {
                    if (!input2.getParameterInput() || !input2.getPrimary()) continue;
                    port = input2.getPort();
                }
                if (port == null) {
                    for (Input input2 : this.inputs()) {
                        if (!input2.getParameterInput()) continue;
                        if (port != null) {
                            this.error("Port not specified and multiple parameter input ports", XProcException.err_E0001);
                        }
                        port = input2.getPort();
                    }
                }
            }
            if (port == null) {
                valid = false;
                this.error("Port not specified and no primary parameter input port", XProcException.err_E0001);
                continue;
            }
            input2 = this.getInput(port);
            if (input2 != null && input2.getParameterInput()) continue;
            valid = false;
            this.error("Port is not a parameter input port: " + port, XProcException.err_E0001);
        }
        return valid;
    }

    protected boolean validBindings() {
        boolean valid = true;
        boolean seenPrimaryDoc = false;
        boolean seenPrimaryParam = false;
        for (Input input : this.inputs()) {
            if (!input.getPort().startsWith("|") && input.getPrimary()) {
                if (input.getParameterInput()) {
                    if (seenPrimaryParam) {
                        this.error("At most one primary parameter input port is allowed", XProcConstants.staticError(30));
                    }
                    seenPrimaryParam = true;
                } else {
                    if (seenPrimaryDoc) {
                        this.error("At most one primary input port is allowed", XProcConstants.staticError(30));
                    }
                    seenPrimaryDoc = true;
                }
            }
            if (this.checkBinding(input)) continue;
            valid = false;
        }
        for (Option option : this.options()) {
            if (!XProcConstants.p_with_option.equals(option.getNode().getNodeName()) || this.checkOptionBinding(option, true)) continue;
            valid = false;
        }
        for (Parameter param : this.parameters()) {
            if (this.checkOptionBinding(param, true)) continue;
            valid = false;
        }
        return valid;
    }

    protected void checkDuplicateVars(HashSet<QName> vars) {
        for (Variable var : this.getVariables()) {
            if (vars.contains(var.getName())) {
                throw XProcException.staticError(4, this.getNode(), "Duplicate variable name: " + var.getName());
            }
            vars.add(var.getName());
        }
    }

    protected boolean checkBinding(Input input) {
        boolean valid = true;
        this.runtime.finest(null, this.node, "Check bindings for " + input.getPort() + " on " + this.getName());
        if (input.getBinding().size() == 0) {
            if (input.getParameterInput()) {
                if (input.getPrimary()) {
                    Step pipeline = this.getPipeline();
                    Port paramsin = null;
                    int count = 0;
                    for (Input input2 : pipeline.inputs()) {
                        if (!input2.getParameterInput()) continue;
                        ++count;
                        if (paramsin != null && !input2.getPrimary()) continue;
                        paramsin = input2;
                    }
                    if (paramsin == null || !paramsin.getPrimary() && count > 1) {
                        if (this.params.size() > 0) {
                            EmptyBinding emptyBinding = new EmptyBinding(this.runtime, this.node);
                            input.addBinding(emptyBinding);
                        } else {
                            valid = false;
                            this.error("Parameter input " + input.getPort() + " unbound on " + this.getType() + " step named " + this.getName() + " and no default binding available.", XProcConstants.staticError(55));
                        }
                    } else {
                        PipeNameBinding pipeNameBinding = new PipeNameBinding(this.runtime, this.node);
                        pipeNameBinding.setStep(pipeline.getName());
                        pipeNameBinding.setPort(paramsin.getPort());
                        input.addBinding(pipeNameBinding);
                    }
                } else {
                    EmptyBinding binding2 = new EmptyBinding(this.runtime, this.node);
                    input.addBinding(binding2);
                }
            } else {
                Port port = this.env.getDefaultReadablePort();
                if (input.getPort().startsWith("|")) {
                    if (this.subpipeline.size() > 0) {
                        Step substep = this.subpipeline.get(this.subpipeline.size() - 1);
                        port = substep.getDefaultOutput();
                    } else if (this.isPipelineCall()) {
                        return true;
                    }
                }
                if (input.getPrimary() && port != null) {
                    String stepName = port.getStep().getName();
                    String portName = port.getPort();
                    PipeNameBinding pipeNameBinding = new PipeNameBinding(this.runtime, this.node);
                    pipeNameBinding.setStep(stepName);
                    pipeNameBinding.setPort(portName);
                    input.addBinding(pipeNameBinding);
                } else {
                    Input declIn = this.declaration.getInput(input.getPort());
                    if (declIn.getBinding().size() != 0) {
                        input.setSelect(declIn.getSelect());
                        for (Binding binding3 : declIn.getBinding()) {
                            input.addBinding(binding3);
                        }
                    } else {
                        valid = false;
                        this.error("Input " + input.getPort() + " unbound on " + this.getType() + " step named " + this.getName() + " and no default binding available.", XProcConstants.staticError(32));
                    }
                }
            }
        }
        boolean catchErrors = false;
        for (Binding binding : input.getBinding()) {
            Step step;
            if (binding.getBindingType() != 1) continue;
            PipeNameBinding pipeNameBinding = (PipeNameBinding)binding;
            Output output = this.env.readablePort(pipeNameBinding.getStep(), pipeNameBinding.getPort());
            if (output == null) {
                Step fromstep = this.env.visibleStep(pipeNameBinding.getStep());
                if (fromstep == null) {
                    throw XProcException.staticError(22, binding.getNode(), "No step named \"" + pipeNameBinding.getStep() + "\" is visible here.");
                }
                if ("error".equals(pipeNameBinding.getPort()) && XProcConstants.p_catch.equals(fromstep.getType())) {
                    catchErrors = true;
                    continue;
                }
                if ("http://www.w3.org/ns/xproc".equals(fromstep.getType().getNamespaceURI()) && this.getVersion() > 1.0) {
                    input.setSequence(true);
                    continue;
                }
                this.error(binding.getNode(), "No port named \"" + pipeNameBinding.getPort() + "\" on step named \"" + pipeNameBinding.getStep() + "\"", XProcConstants.staticError(22));
                valid = false;
                continue;
            }
            if (pipeNameBinding.getPort().equals(output.getPort()) || !XProcConstants.p_viewport.equals((step = this.env.visibleStep(pipeNameBinding.getStep())).getType())) continue;
            pipeNameBinding.setPort(output.getPort());
        }
        if (catchErrors) {
            Vector<Binding> newBindings = new Vector<Binding>();
            SourceArtifact fromstep = null;
            for (Binding binding : input.getBinding()) {
                PipeNameBinding pipe;
                Output output;
                catchErrors = false;
                if (binding.getBindingType() == 1 && (output = this.env.readablePort((pipe = (PipeNameBinding)binding).getStep(), pipe.getPort())) == null) {
                    fromstep = this.env.visibleStep(pipe.getStep());
                    if ("error".equals(pipe.getPort()) && XProcConstants.p_catch.equals(((Step)fromstep).getType())) {
                        catchErrors = true;
                    }
                }
                if (catchErrors) {
                    newBindings.add(new ErrorBinding(fromstep.getXProc(), ((Step)fromstep).getNode()));
                    continue;
                }
                newBindings.add(binding);
            }
            input.clearBindings();
            for (Binding binding : newBindings) {
                input.addBinding(binding);
            }
        }
        return valid;
    }

    protected boolean checkOptionBinding(EndPoint endpoint) {
        return this.checkOptionBinding(endpoint, false);
    }

    protected boolean checkOptionBinding(EndPoint endpoint, boolean defEmpty) {
        boolean valid = true;
        this.runtime.finest(null, this.node, "Check bindings for " + endpoint + " on " + this.getName());
        if (endpoint.getBinding().size() == 0) {
            Port port = this.env.getDefaultReadablePort();
            if (port == null) {
                if (defEmpty) {
                    EmptyBinding empty = new EmptyBinding(this.runtime, this.node);
                    endpoint.addBinding(empty);
                } else {
                    valid = false;
                    this.error(endpoint + " unbound on " + this.getType() + " step named " + this.getName() + " and no default readable port.", XProcConstants.staticError(32));
                }
            } else {
                String stepName = port.getStep().getName();
                String portName = port.getPort();
                Binding binding = new PipeNameBinding(this.runtime, this.node);
                ((PipeNameBinding)binding).setStep(stepName);
                ((PipeNameBinding)binding).setPort(portName);
                endpoint.addBinding(binding);
            }
        }
        boolean catchErrors = false;
        for (Binding binding : endpoint.getBinding()) {
            if (binding.getBindingType() != 1) continue;
            PipeNameBinding pipe = (PipeNameBinding)binding;
            Output output = this.env.readablePort(pipe.getStep(), pipe.getPort());
            if (output == null) {
                Step fromstep = this.env.visibleStep(pipe.getStep());
                if ("error".equals(pipe.getPort()) && XProcConstants.p_catch.equals(fromstep.getType())) {
                    catchErrors = true;
                    continue;
                }
                this.error("Unreadable port: " + pipe.getPort() + " on " + pipe.getStep(), XProcConstants.staticError(22));
                valid = false;
                continue;
            }
            if (!XProcConstants.p_variable.equals(endpoint.getNode().getNodeName())) continue;
            Step pipeStep = this.env.visibleStep(pipe.getStep());
            Step container = pipeStep.parent;
            if (container != this) continue;
            throw XProcException.staticError(19, endpoint.getNode(), "Variable binding to " + pipe.getPort() + " on " + pipe.getStep() + " not allowed.");
        }
        if (catchErrors) {
            Vector<Binding> newBindings = new Vector<Binding>();
            SourceArtifact fromstep = null;
            for (Binding binding : endpoint.getBinding()) {
                PipeNameBinding pipe;
                Output output;
                catchErrors = false;
                if (binding.getBindingType() == 1 && (output = this.env.readablePort((pipe = (PipeNameBinding)binding).getStep(), pipe.getPort())) == null) {
                    fromstep = this.env.visibleStep(pipe.getStep());
                    if ("error".equals(pipe.getPort()) && XProcConstants.p_catch.equals(((Step)fromstep).getType())) {
                        catchErrors = true;
                    }
                }
                if (catchErrors) {
                    newBindings.add(new ErrorBinding(fromstep.getXProc(), ((Step)fromstep).getNode()));
                    continue;
                }
                newBindings.add(binding);
            }
            endpoint.clearBindings();
            for (Binding binding : newBindings) {
                endpoint.addBinding(binding);
            }
        }
        return valid;
    }

    protected void checkForBindings(HashSet<Output> outputs) {
        PipeNameBinding b;
        Output output;
        for (Input input : this.inputs()) {
            for (Binding binding : input.bindings) {
                if (binding.getBindingType() != 1 || !outputs.contains(output = this.env.readablePort((b = (PipeNameBinding)binding).getStep(), b.getPort()))) continue;
                outputs.remove(output);
            }
        }
        for (Option option : this.options()) {
            for (Binding binding : option.bindings) {
                if (binding.getBindingType() != 1 || !outputs.contains(output = this.env.readablePort((b = (PipeNameBinding)binding).getStep(), b.getPort()))) continue;
                outputs.remove(output);
            }
        }
        for (Parameter param : this.parameters()) {
            for (Binding binding : param.bindings) {
                if (binding.getBindingType() != 1 || !outputs.contains(output = this.env.readablePort((b = (PipeNameBinding)binding).getStep(), b.getPort()))) continue;
                outputs.remove(output);
            }
        }
    }

    public boolean orderSteps() {
        PipeNameBinding pipe;
        boolean valid = true;
        if (this.ordered) {
            return true;
        }
        this.ordered = true;
        for (Step step : this.subpipeline) {
            if (step.orderSteps()) continue;
            valid = false;
        }
        this.runtime.finest(null, this.node, "Checking step order for " + this.getName());
        if (this.getExtensionAttribute(cx_depend) != null || this.getExtensionAttribute(cx_depends) != null || this.getExtensionAttribute(cx_dependson) != null) {
            throw new XProcException(this.getNode(), "The correct spelling of the depends-on attribute is cx:depends-on.");
        }
        String dependsOn = this.getExtensionAttribute(XProcConstants.cx_depends_on);
        if (dependsOn != null) {
            Step step = this.env.visibleStep(dependsOn);
            if (step == null) {
                throw new XProcException(this.getNode(), "The value of cx:depends-on must be the name of an in-scope step: " + dependsOn);
            }
            this.addDependency(dependsOn);
        }
        for (Input input : this.inputs) {
            for (Binding binding : input.getBinding()) {
                if (binding.getBindingType() != 1) continue;
                pipe = (PipeNameBinding)binding;
                this.runtime.finest(null, this.node, String.valueOf(this.getName()) + " input " + input.getPort() + " depends on " + pipe.getStep());
                this.addDependency(pipe.getStep());
            }
        }
        for (Parameter param : this.params) {
            for (Binding binding : param.getBinding()) {
                if (binding.getBindingType() != 1) continue;
                pipe = (PipeNameBinding)binding;
                this.runtime.finest(null, this.node, String.valueOf(this.getName()) + " param depends on " + pipe.getStep());
                this.addDependency(pipe.getStep());
            }
        }
        for (Option option : this.options) {
            for (Binding binding : option.getBinding()) {
                if (binding.getBindingType() != 1) continue;
                pipe = (PipeNameBinding)binding;
                this.runtime.finest(null, this.node, String.valueOf(this.getName()) + " option depends on " + pipe.getStep());
                this.addDependency(pipe.getStep());
            }
        }
        this.checkVariables();
        Vector<Step> roots = new Vector<Step>();
        for (Step step : this.subpipeline) {
            HashSet<String> deps = step.getDependencies();
            boolean root = true;
            for (String string : deps) {
                if (!string.equals(this.getName())) {
                    this.runtime.finest(null, this.node, String.valueOf(this.getName()) + " step " + step.getName() + " depends on " + string);
                    this.addDependency(string);
                }
                if (!this.containsStep(string)) continue;
                root = false;
            }
            if (!root) continue;
            this.runtime.finest(null, this.node, "==> " + step.getName() + " is a graph root of " + this.getName());
            roots.add(step);
            step.depth = 0;
        }
        if (this.subpipeline.size() > 0) {
            if (roots.size() == 0) {
                this.error("No roots in " + this.getName(), XProcConstants.staticError(1));
                valid = false;
            } else {
                boolean bl;
                boolean bl2;
                int depth = 1;
                boolean bl3 = true;
                while (bl2 && roots.size() > 0) {
                    Vector<Step> nextWave = new Vector<Step>();
                    for (Step root : roots) {
                        for (Step step : this.subpipeline) {
                            if (step.dependsOn(root.getName())) {
                                this.runtime.finest(null, this.node, "XProcStep " + step.getName() + " depends on " + root.getName() + "(step.depth=" + step.depth + ", depth=" + depth + ")");
                                if (step.depth < 0 || depth >= step.depth) {
                                    step.depth = depth;
                                    this.runtime.finest(null, this.node, String.valueOf(step.getName()) + " gets depth " + depth);
                                    nextWave.add(step);
                                    continue;
                                }
                                bl2 = false;
                                this.error("Loop in subpipeline: " + step.getName() + " points back to " + root.getName(), XProcConstants.staticError(1));
                                continue;
                            }
                            this.runtime.finest(null, this.node, "XProcStep " + step.getName() + " does not depend on " + root.getName());
                        }
                    }
                    roots = nextWave;
                    ++depth;
                }
                if (bl2) {
                    for (Step step : this.subpipeline) {
                        if (step.depth >= 0) continue;
                        bl = false;
                        this.error("Closed loop in subpipeline involves: " + step.getName(), XProcConstants.staticError(1));
                    }
                }
                boolean bl4 = valid = valid && bl;
                if (valid) {
                    Vector<Step> sorted = new Vector<Step>();
                    int wave = 0;
                    while (wave < depth) {
                        for (Step step : this.subpipeline) {
                            if (step.depth != wave) continue;
                            sorted.add(step);
                        }
                        ++wave;
                    }
                    this.subpipeline = sorted;
                }
            }
        }
        return valid;
    }

    public void checkVariables() {
    }

    public boolean valid() {
        boolean valid = this.validParams();
        if (!this.matchesDeclaration()) {
            valid = false;
        }
        if (!this.validOptions()) {
            valid = false;
        }
        if (!this.validBindings()) {
            valid = false;
        }
        for (Log log : this.logs) {
            Output output = this.getOutput(log.getPort());
            if (output != null) continue;
            this.error("A p:log specified for a bad port: " + log.getPort(), XProcConstants.staticError(26));
            valid = false;
        }
        if (this.env.countVisibleSteps(this.getName()) > 1) {
            this.error("Duplicate step name: " + this.getName(), XProcConstants.staticError(2));
            valid = false;
        }
        return valid;
    }

    protected void augmentIO() {
        DeclareStep decl = this.declaration;
        if (decl == null) {
            throw new UnsupportedOperationException("Unexpected step type.");
        }
        Hashtable<String, Input> declInputs = new Hashtable<String, Input>();
        for (Input input : decl.inputs()) {
            declInputs.put(input.getPort(), input);
        }
        int position = 0;
        for (Input input : this.inputs()) {
            ++position;
        }
        for (Parameter param : this.parameters()) {
            ++position;
        }
        for (String portName : declInputs.keySet()) {
            Input dinput = (Input)declInputs.get(portName);
            Input input = this.getInput(portName);
            if (input == null) {
                this.runtime.finest(null, this.node, "Added " + portName + " input to " + this.getName());
                input = new Input(this.runtime, this.node);
                input.setPort(portName);
                input.setParameterInput(dinput.getParameterInput());
                if (dinput.getPrimarySet()) {
                    input.setPrimary(dinput.getPrimary());
                }
                input.setSequence(dinput.getSequence());
                input.setPosition(++position);
                this.addInput(input);
                continue;
            }
            input.setParameterInput(dinput.getParameterInput());
            input.setPrimary(dinput.getPrimary());
            input.setSequence(dinput.getSequence());
        }
        Hashtable<String, Output> declOutputs = new Hashtable<String, Output>();
        for (Output output : decl.outputs()) {
            declOutputs.put(output.getPort(), output);
        }
        for (String portName : declOutputs.keySet()) {
            Output doutput = (Output)declOutputs.get(portName);
            Output output = this.getOutput(portName);
            if (output != null) continue;
            this.runtime.finest(null, this.node, "Added " + portName + " output to " + this.getName());
            output = new Output(this.runtime, this.node);
            output.setPort(portName);
            output.setSequence(doutput.getSequence());
            if (doutput.getPrimarySet()) {
                output.setPrimary(doutput.getPrimary());
            }
            this.addOutput(output);
        }
    }

    protected void augmentOptions() {
        DeclareStep decl = this.declaration;
        if (decl == null) {
            throw new UnsupportedOperationException("Unexpected step type: " + this.getType());
        }
        Hashtable<QName, Option> declOptions = new Hashtable<QName, Option>();
        for (Option option : decl.options()) {
            declOptions.put(option.getName(), option);
        }
        for (QName oname : declOptions.keySet()) {
            Option doption = (Option)declOptions.get(oname);
            Option option = this.getOption(oname);
            if (option == null) {
                if (doption.getSelect() == null && doption.getBinding().size() == 0) continue;
                this.addOption(doption);
                continue;
            }
            option.setType(doption.getType(), doption.getNode());
        }
    }

    public void augment() {
        this.augmentIO();
        this.augmentOptions();
    }

    public void patchPipeBindings() {
        for (Input input : this.inputs) {
            this.patchInputBindings(input);
        }
        for (Parameter param : this.params) {
            this.patchInputBindings(param);
        }
        for (Option option : this.options) {
            this.patchInputBindings(option);
        }
        for (Variable var : this.getVariables()) {
            this.patchInputBindings(var);
        }
        for (Step step : this.subpipeline) {
            step.patchPipeBindings();
        }
    }

    protected void patchInputBindings(EndPoint endpoint) {
        Vector<Binding> bindings = endpoint.getBinding();
        int bpos = 0;
        while (bpos < bindings.size()) {
            Binding binding = bindings.get(bpos);
            if (binding.getBindingType() == 1) {
                PipeNameBinding pipename = (PipeNameBinding)binding;
                PipeBinding pipe = new PipeBinding(this.runtime, pipename.node);
                Output source = this.env.readablePort(pipename.getStep(), pipename.getPort());
                pipe.setOutput(source);
                pipe.setInput(endpoint);
                bindings.set(bpos, pipe);
                if (source != null) {
                    source.addBinding(pipe);
                }
            }
            ++bpos;
        }
    }

    protected void setEnvironment(Environment newEnvironment) {
        this.env = newEnvironment;
    }

    protected void patchEnvironment(Environment env) {
    }

    public Environment getEnvironment() {
        return this.env;
    }

    public String toString() {
        String str = null;
        str = this.stepName.startsWith("#") ? "anonymous step " + this.stepType : "step " + this.stepType + " named " + this.stepName;
        str = this.node.getLineNumber() > 0 ? String.valueOf(str) + " at " + this.node.getDocumentURI() + ":" + this.node.getLineNumber() : String.valueOf(str) + " in " + this.node.getDocumentURI();
        return str;
    }

    public void dump() {
        System.err.println("============================================================================");
        this.dump(0);
        System.err.println("");
    }

    protected void dump(int depth) {
        String indent = "";
        int count = 0;
        while (count < depth) {
            indent = String.valueOf(indent) + " ";
            ++count;
        }
        if (this.getType().getNamespaceURI().equals("http://www.w3.org/ns/xproc")) {
            System.err.println(String.valueOf(indent) + this.getType().getLocalName() + " " + this.getName());
        } else {
            System.err.println(String.valueOf(indent) + "XProcStep " + this.getName() + " (" + this.getType() + ")");
        }
        for (Input input : this.inputs) {
            input.dump(depth + 2);
        }
        for (Output output : this.outputs) {
            output.dump(depth + 2);
        }
        for (Parameter param : this.params) {
            param.dump(depth + 2);
        }
        for (Option option : this.options) {
            option.dump(depth + 2);
        }
        for (Variable var : this.getVariables()) {
            var.dump(depth + 2);
        }
        for (Step step : this.subpipeline) {
            step.dump(depth + 2);
        }
    }
}

