/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.model;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.model.Binding;
import com.xmlcalabash.model.ComputableValue;
import com.xmlcalabash.model.EndPoint;
import com.xmlcalabash.model.Environment;
import com.xmlcalabash.model.NamespaceBinding;
import java.util.Vector;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;

public class Option
extends EndPoint
implements ComputableValue {
    private QName name = null;
    private boolean required = false;
    private String select = null;
    private String type = null;
    private XdmNode typeNode = null;
    private Vector<NamespaceBinding> nsBindings = new Vector();

    public Option(XProcRuntime xproc, XdmNode node) {
        super(xproc, node);
    }

    public void setName(QName name) {
        this.name = name;
    }

    @Override
    public QName getName() {
        return this.name;
    }

    public void setType(String type, XdmNode node) {
        this.type = type;
        this.typeNode = node;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public QName getTypeAsQName() {
        return new QName(this.type, this.typeNode);
    }

    public void setRequired(String required) {
        this.required = "true".equals(required);
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean getRequired() {
        return this.required;
    }

    public void setSelect(String select) {
        this.select = select;
    }

    @Override
    public String getSelect() {
        return this.select;
    }

    @Override
    public void addNamespaceBinding(NamespaceBinding binding) {
        this.nsBindings.add(binding);
    }

    @Override
    public Vector<NamespaceBinding> getNamespaceBindings() {
        return this.nsBindings;
    }

    public boolean valid(Environment env) {
        boolean valid = true;
        if (this.bindings.size() > 1) {
            this.error("Option can have at most one binding.", XProcConstants.dynamicError(8));
            valid = false;
        }
        if (this.required && this.select != null) {
            this.error("You can't specify a default value on a required option", XProcConstants.staticError(17));
        }
        return valid;
    }

    public String toString() {
        if (XProcConstants.p_option.equals(this.node.getNodeName())) {
            return "with-option " + this.name;
        }
        return "option " + this.name;
    }

    protected void dump(int depth) {
        String indent = "";
        int count = 0;
        while (count < depth) {
            indent = String.valueOf(indent) + " ";
            ++count;
        }
        if (this.select != null) {
            System.err.println(String.valueOf(indent) + "option " + this.getName() + " select=" + this.select);
        } else {
            System.err.println(String.valueOf(indent) + "option " + this.getName());
            if (this.getBinding().size() == 0 && !XProcConstants.p_option.equals(this.node.getNodeName())) {
                System.err.println(String.valueOf(indent) + "  no binding");
            }
        }
        for (Binding binding : this.getBinding()) {
            binding.dump(depth + 2);
        }
    }
}

