/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.TreeWriter;
import com.xmlcalabash.util.TypeUtils;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;

public class WWWFormURLDecode
extends DefaultStep {
    public static final QName _value = new QName("", "value");
    public static final QName _name = new QName("", "name");
    public static final QName c_paramset = new QName("c", "http://www.w3.org/ns/xproc-step", "param-set");
    public static final QName c_param = new QName("c", "http://www.w3.org/ns/xproc-step", "param");
    private WritablePipe result = null;

    public WWWFormURLDecode(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        String value = this.getOption(_value).getString();
        TreeWriter tree = new TreeWriter(this.runtime);
        tree.startDocument(this.step.getNode().getBaseURI());
        tree.addStartElement(c_paramset);
        tree.startContent();
        String[] params = value.split("&");
        int idx = 0;
        while (idx < params.length) {
            String val;
            String name;
            String p = params[idx];
            int pos = p.indexOf("=");
            if (pos > 0) {
                name = p.substring(0, pos);
                val = p.substring(pos + 1);
                try {
                    TypeUtils.checkType(this.runtime, name, XProcConstants.xs_NCName, null);
                }
                catch (XProcException e) {
                    throw XProcException.stepError(61);
                }
            } else {
                throw new XProcException(this.step.getNode(), "Badly formatted parameters");
            }
            tree.addStartElement(c_param);
            tree.addAttribute(_name, name);
            tree.addAttribute(_value, this.decode(val));
            tree.startContent();
            tree.addEndElement();
            ++idx;
        }
        tree.addEndElement();
        tree.endDocument();
        this.result.write(tree.getResult());
    }

    private String decode(String val) {
        int pos;
        String result = "";
        while ((pos = val.indexOf("%")) >= 0) {
            result = String.valueOf(result) + val.substring(0, pos);
            try {
                String digits = val.substring(pos + 1, pos + 3);
                int dec = Integer.parseInt(digits, 16);
                char ch = (char)dec;
                result = String.valueOf(result) + ch;
            }
            catch (StringIndexOutOfBoundsException ex) {
                throw new XProcException("Badly formatted parameters", (Throwable)ex);
            }
            catch (NumberFormatException ex) {
                throw new XProcException("Badly formatted parameters", (Throwable)ex);
            }
            val = val.substring(pos + 3);
        }
        result = String.valueOf(result) + val;
        return result;
    }
}

