/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.Base64;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TreeWriter;
import com.xmlcalabash.util.XMLtoJSON;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URLConnection;
import java.util.zip.GZIPOutputStream;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;

public class Store
extends DefaultStep {
    private static final QName _href = new QName("href");
    private static final QName _encoding = new QName("encoding");
    private static final QName _content_type = new QName("content-type");
    private static final QName c_encoding = new QName("c", "http://www.w3.org/ns/xproc-step", "encoding");
    private static final QName c_body = new QName("c", "http://www.w3.org/ns/xproc-step", "body");
    private static final QName c_json = new QName("c", "http://www.w3.org/ns/xproc-step", "json");
    private static final QName cx_decode = new QName("cx", "http://xmlcalabash.com/ns/extensions", "decode");
    private ReadablePipe source = null;
    private WritablePipe result = null;
    protected CompressionMethod method = CompressionMethod.NONE;
    private URI href = null;

    public Store(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        if (this.runtime.getSafeMode()) {
            throw XProcException.dynamicError(21);
        }
        RuntimeValue hrefOpt = this.getOption(_href);
        XdmNode doc = this.source.read();
        if (doc == null || this.source.moreDocuments()) {
            throw XProcException.dynamicError(6);
        }
        if (hrefOpt != null) {
            this.href = hrefOpt.getBaseURI().resolve(hrefOpt.getString());
        }
        if (this.method == CompressionMethod.GZIP) {
            this.finer(hrefOpt == null ? null : hrefOpt.getNode(), "Gzipping" + (this.href == null ? "" : " to \"" + this.href + "\"."));
        } else {
            this.finer(hrefOpt.getNode(), "Storing to \"" + this.href + "\".");
        }
        String decode = this.step.getExtensionAttribute(cx_decode);
        XdmNode root = S9apiUtils.getDocumentElement(doc);
        if (("true".equals(decode) || "1".equals(decode) || this.method != CompressionMethod.NONE) && ("http://www.w3.org/ns/xproc-step".equals(root.getNodeName().getNamespaceURI()) && "base64".equals(root.getAttributeValue(_encoding)) || "".equals(root.getNodeName().getNamespaceURI()) && "base64".equals(root.getAttributeValue(c_encoding)))) {
            this.storeBinary(doc, this.href);
        } else if (this.runtime.transparentJSON() && (c_body.equals(root.getNodeName()) && ("application/json".equals(root.getAttributeValue(_content_type)) || "text/json".equals(root.getAttributeValue(_content_type))) || c_json.equals(root.getNodeName()) || "http://www.ibm.com/xmlns/prod/2009/jsonx".equals(root.getNodeName().getNamespaceURI()) || "http://www.xmlsh.org/jxml".equals(root.getNodeName().getNamespaceURI()) || "http://marklogic.com/json".equals(root.getNodeName().getNamespaceURI()))) {
            this.storeJSON(doc, this.href);
        } else {
            this.storeXML(doc, this.href);
        }
        if (this.href != null) {
            TreeWriter tree = new TreeWriter(this.runtime);
            tree.startDocument(this.step.getNode().getBaseURI());
            tree.addStartElement(XProcConstants.c_result);
            tree.startContent();
            tree.addText(this.href.toString());
            tree.addEndElement();
            tree.endDocument();
            this.result.write(tree.getResult());
        }
    }

    private void storeXML(XdmNode doc, URI href) throws SaxonApiException {
        Serializer serializer = this.makeSerializer();
        try {
            OutputStream outstr = null;
            ByteArrayOutputStream baos = null;
            if (href == null) {
                baos = new ByteArrayOutputStream();
                outstr = baos;
            } else if (href.getScheme().equals("file")) {
                File output = new File(href);
                File path = new File(output.getParent());
                if (!path.isDirectory() && !path.mkdirs()) {
                    throw XProcException.stepError(50);
                }
                outstr = new FileOutputStream(output);
            } else {
                URLConnection conn = href.toURL().openConnection();
                conn.setDoOutput(true);
                outstr = conn.getOutputStream();
            }
            if (this.method == CompressionMethod.GZIP) {
                GZIPOutputStream gzout = new GZIPOutputStream(outstr);
                outstr = gzout;
            }
            serializer.setOutputStream(outstr);
            S9apiUtils.serialize(this.runtime, doc, serializer);
            outstr.close();
            if (href == null) {
                this.returnData(baos);
            }
        }
        catch (IOException ioe) {
            throw XProcException.stepError(50, ioe);
        }
    }

    private void storeBinary(XdmNode doc, URI href) {
        try {
            byte[] decoded = Base64.decode(doc.getStringValue());
            OutputStream outstr = null;
            ByteArrayOutputStream baos = null;
            if (href == null) {
                outstr = baos = new ByteArrayOutputStream();
            } else {
                File output = new File(href);
                File path = new File(output.getParent());
                if (!path.isDirectory() && !path.mkdirs()) {
                    throw XProcException.stepError(50);
                }
                outstr = new FileOutputStream(output);
            }
            if (this.method == CompressionMethod.GZIP) {
                GZIPOutputStream gzout = new GZIPOutputStream(outstr);
                outstr = gzout;
            }
            outstr.write(decoded);
            ((OutputStream)outstr).close();
            if (href == null) {
                this.returnData(baos);
            }
        }
        catch (IOException ioe) {
            throw new XProcException(ioe);
        }
    }

    private void storeJSON(XdmNode doc, URI href) throws SaxonApiException {
        try {
            OutputStream outstr = null;
            ByteArrayOutputStream baos = null;
            if (href == null) {
                baos = new ByteArrayOutputStream();
                outstr = baos;
            } else if (href.getScheme().equals("file")) {
                File output = new File(href);
                File path = new File(output.getParent());
                if (!path.isDirectory() && !path.mkdirs()) {
                    throw XProcException.stepError(50);
                }
                outstr = new FileOutputStream(output);
            } else {
                URLConnection conn = href.toURL().openConnection();
                conn.setDoOutput(true);
                outstr = conn.getOutputStream();
            }
            if (this.method == CompressionMethod.GZIP) {
                GZIPOutputStream gzout = new GZIPOutputStream(outstr);
                outstr = gzout;
            }
            PrintWriter writer = new PrintWriter(outstr);
            String json = XMLtoJSON.convert(doc);
            writer.print(json);
            writer.close();
            outstr.close();
            if (href == null) {
                this.returnData(baos);
            }
        }
        catch (IOException ioe) {
            throw XProcException.stepError(50, ioe);
        }
    }

    public void returnData(ByteArrayOutputStream baos) {
        TreeWriter tree = new TreeWriter(this.runtime);
        tree.startDocument(this.step.getNode().getBaseURI());
        tree.addStartElement(XProcConstants.c_data);
        tree.addAttribute(_encoding, "base64");
        tree.addAttribute(_content_type, "application/x-gzip");
        tree.startContent();
        tree.addText(Base64.encodeBytes(baos.toByteArray()));
        tree.addEndElement();
        tree.endDocument();
        this.result.write(tree.getResult());
    }

    protected static enum CompressionMethod {
        NONE,
        GZIP;

    }
}

