/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.Base64;
import com.xmlcalabash.util.ProcessMatch;
import com.xmlcalabash.util.ProcessMatchingNodes;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import java.util.zip.CRC32;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;

public class Hash
extends DefaultStep
implements ProcessMatchingNodes {
    private static final QName _value = new QName("", "value");
    private static final QName _algorithm = new QName("", "algorithm");
    private static final QName _version = new QName("", "version");
    private static final QName _match = new QName("", "match");
    private static final QName _crc = new QName("", "crc");
    private static final QName _md = new QName("", "md");
    private static final QName _sha = new QName("", "sha");
    private static final QName _hmac = new QName("cx", "http://xmlcalabash.com/ns/extensions", "hmac");
    private static final QName _accessKey = new QName("cx", "http://xmlcalabash.com/ns/extensions", "accessKey");
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";
    private Hashtable<QName, String> params = new Hashtable();
    protected static final String logger = "org.xproc.library.hash";
    private ReadablePipe source = null;
    private WritablePipe result = null;
    private ProcessMatch matcher = null;
    private String hash = null;

    public Hash(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void setParameter(QName name, RuntimeValue value) {
        this.params.put(name, value.getString());
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        String value = this.getOption(_value).getString();
        QName algorithm = this.getOption(_algorithm).getQName();
        String version = null;
        if (this.getOption(_version) != null) {
            version = this.getOption(_version).getString();
        }
        if (_crc.equals(algorithm)) {
            this.hash = this.crc(value, version);
        } else if (_md.equals(algorithm)) {
            this.hash = this.md(value, version);
        } else if (_sha.equals(algorithm)) {
            this.hash = this.sha(value, version);
        } else if (_hmac.equals(algorithm)) {
            this.hash = Hash.hmac(value, this.params.get(_accessKey));
        } else {
            throw XProcException.dynamicError(36);
        }
        this.matcher = new ProcessMatch(this.runtime, this);
        this.matcher.match(this.source.read(), this.getOption(_match));
        if (this.source.moreDocuments()) {
            throw XProcException.dynamicError(6);
        }
        this.result.write(this.matcher.getResult());
    }

    private String crc(String value, String version) {
        if (version == null) {
            version = "32";
        }
        if (!"32".equals(version)) {
            throw XProcException.dynamicError(36);
        }
        CRC32 crc = new CRC32();
        crc.update(value.getBytes());
        return Long.toHexString(crc.getValue());
    }

    private String md(String value, String version) {
        MessageDigest digest = null;
        if (version == null) {
            version = "5";
        }
        try {
            digest = MessageDigest.getInstance("MD" + version);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw XProcException.dynamicError(36);
        }
        byte[] hash = digest.digest(value.getBytes());
        String result = "";
        byte[] byArray = hash;
        int n = hash.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            String str = Integer.toHexString(b & 0xFF);
            if (str.length() < 2) {
                str = "0" + str;
            }
            result = String.valueOf(result) + str;
            ++n2;
        }
        return result;
    }

    private String sha(String value, String version) {
        MessageDigest digest = null;
        if (version == null) {
            version = "1";
        }
        try {
            digest = MessageDigest.getInstance("SHA-" + version);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw XProcException.dynamicError(36);
        }
        byte[] hash = digest.digest(value.getBytes());
        String result = "";
        byte[] byArray = hash;
        int n = hash.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            String str = Integer.toHexString(b & 0xFF);
            if (str.length() < 2) {
                str = "0" + str;
            }
            result = String.valueOf(result) + str;
            ++n2;
        }
        return result;
    }

    private static String hmac(String data, String key) {
        String result = "";
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key.getBytes(), HMAC_SHA1_ALGORITHM);
            Mac mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
            mac.init(signingKey);
            byte[] rawHmac = mac.doFinal(data.getBytes());
            result = Base64.encodeBytes(rawHmac);
        }
        catch (Exception e) {
            throw XProcException.dynamicError(36, "Failed to generate HMAC : " + e.getMessage());
        }
        return result;
    }

    @Override
    public boolean processStartDocument(XdmNode node) throws SaxonApiException {
        return true;
    }

    @Override
    public void processEndDocument(XdmNode node) throws SaxonApiException {
    }

    @Override
    public boolean processStartElement(XdmNode node) throws SaxonApiException {
        this.matcher.addText(this.hash);
        return false;
    }

    @Override
    public void processEndElement(XdmNode node) throws SaxonApiException {
    }

    @Override
    public void processText(XdmNode node) throws SaxonApiException {
        this.matcher.addText(this.hash);
    }

    @Override
    public void processComment(XdmNode node) throws SaxonApiException {
        this.matcher.addComment(this.hash);
    }

    @Override
    public void processPI(XdmNode node) throws SaxonApiException {
        this.matcher.addPI(node.getNodeName().getLocalName(), this.hash);
    }

    @Override
    public void processAttribute(XdmNode node) throws SaxonApiException {
        this.matcher.addAttribute(node.getNodeName(), this.hash);
    }
}

