/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.functions;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.functions.XProcExtensionFunctionDefinition;
import com.xmlcalabash.runtime.XCompoundStep;
import com.xmlcalabash.runtime.XStep;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.SequenceType;

public class ValueAvailable
extends XProcExtensionFunctionDefinition {
    private static StructuredQName funcname = new StructuredQName("p", "http://www.w3.org/ns/xproc", "value-available");

    protected ValueAvailable() {
    }

    public ValueAvailable(XProcRuntime runtime) {
        this.tl_runtime.set(runtime);
    }

    @Override
    public StructuredQName getFunctionQName() {
        return funcname;
    }

    @Override
    public int getMinimumNumberOfArguments() {
        return 1;
    }

    @Override
    public int getMaximumNumberOfArguments() {
        return 2;
    }

    @Override
    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_STRING, SequenceType.OPTIONAL_BOOLEAN};
    }

    @Override
    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.SINGLE_ATOMIC;
    }

    @Override
    public ExtensionFunctionCall makeCallExpression() {
        return new ValueAvailableCall();
    }

    private class ValueAvailableCall
    extends ExtensionFunctionCall {
        private StaticContext staticContext = null;

        private ValueAvailableCall() {
        }

        @Override
        public void supplyStaticContext(StaticContext context, int locationId, Expression[] arguments) throws XPathException {
            this.staticContext = context;
        }

        @Override
        public Sequence call(XPathContext xPathContext, Sequence[] sequences) throws XPathException {
            StructuredQName sVarName = null;
            XProcRuntime runtime = (XProcRuntime)ValueAvailable.this.tl_runtime.get();
            XStep step = runtime.getXProcData().getStep();
            if (step != null && !(step instanceof XCompoundStep)) {
                throw XProcException.dynamicError(23);
            }
            try {
                String lexicalQName = sequences[0].head().getStringValue();
                sVarName = StructuredQName.fromLexicalQName(lexicalQName, false, false, xPathContext.getConfiguration().getNameChecker(), this.staticContext.getNamespaceResolver());
            }
            catch (XPathException e) {
                throw new XProcException("Invalid variable/option name. " + e.getMessage() + "XTDE1390");
            }
            boolean failIfUnknown = true;
            if (sequences.length > 1) {
                failIfUnknown = ((BooleanValue)sequences[1].head()).effectiveBooleanValue();
            }
            boolean value = false;
            QName varName = new QName(sVarName.getURI(), sVarName.getLocalPart());
            value = step.hasInScopeVariableBinding(varName);
            if (!value) {
                if (failIfUnknown) {
                    throw XProcException.dynamicError(33);
                }
            } else {
                value = step.hasInScopeVariableValue(varName);
            }
            return value ? BooleanValue.TRUE : BooleanValue.FALSE;
        }
    }
}

