/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions.fileutils;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.TreeWriter;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;

public class Tempfile
extends DefaultStep {
    private static final QName _href = new QName("href");
    private static final QName _prefix = new QName("prefix");
    private static final QName _suffix = new QName("suffix");
    private static final QName _delete_on_exit = new QName("delete-on-exit");
    private WritablePipe result = null;

    public Tempfile(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        File temp;
        super.run();
        if (this.runtime.getSafeMode()) {
            throw XProcException.dynamicError(21);
        }
        String prefix = "temp";
        String suffix = ".xml";
        boolean delete = false;
        RuntimeValue value = this.getOption(_prefix);
        if (value != null) {
            prefix = value.getString();
        }
        if ((value = this.getOption(_suffix)) != null) {
            suffix = value.getString();
        }
        delete = this.getOption(_delete_on_exit, false);
        RuntimeValue href = this.getOption(_href);
        URI uri = href.getBaseURI().resolve(href.getString());
        if (!"file".equals(uri.getScheme())) {
            throw new XProcException(this.step.getNode(), "Only file: scheme URIs are supported by the tempfile step.");
        }
        File file = new File(uri.getPath());
        if (!file.isDirectory()) {
            throw new XProcException(this.step.getNode(), "The href on tempfile must point to an existing directory.");
        }
        TreeWriter tree = new TreeWriter(this.runtime);
        tree.startDocument(this.step.getNode().getBaseURI());
        tree.addStartElement(XProcConstants.c_result);
        tree.startContent();
        try {
            temp = File.createTempFile(prefix, suffix, file);
        }
        catch (IOException ioe) {
            throw new XProcException(this.step.getNode(), "Failed to create temporary file in " + file.toURI().toASCIIString());
        }
        if (delete) {
            temp.deleteOnExit();
        }
        tree.addText(temp.toURI().toASCIIString());
        tree.addEndElement();
        tree.endDocument();
        this.result.write(tree.getResult());
    }
}

