/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions.fileutils;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.TreeWriter;
import java.io.File;
import java.net.URI;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;

public class Mkdir
extends DefaultStep {
    private static final QName _href = new QName("href");
    private WritablePipe result = null;

    public Mkdir(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        if (this.runtime.getSafeMode()) {
            throw XProcException.dynamicError(21);
        }
        RuntimeValue href = this.getOption(_href);
        URI uri = href.getBaseURI().resolve(href.getString());
        if (!"file".equals(uri.getScheme())) {
            throw new XProcException(this.step.getNode(), "Only file: scheme URIs are supported by the mkdir step.");
        }
        File file = new File(uri.getPath());
        TreeWriter tree = new TreeWriter(this.runtime);
        tree.startDocument(this.step.getNode().getBaseURI());
        tree.addStartElement(XProcConstants.c_result);
        tree.startContent();
        tree.addText(file.toURI().toASCIIString());
        if (!file.exists() || !file.isDirectory()) {
            if (file.exists()) {
                throw new XProcException(this.step.getNode(), "Cannot mkdir: file exists: " + file.getAbsolutePath());
            }
            if (!file.mkdirs()) {
                throw new XProcException(this.step.getNode(), "Mkdir failed for: " + file.getAbsolutePath());
            }
        }
        tree.addEndElement();
        tree.endDocument();
        this.result.write(tree.getResult());
    }
}

