/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions.fileutils;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.TreeWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;

public class Head
extends DefaultStep {
    private static final QName _href = new QName("href");
    private static final QName _count = new QName("count");
    private static final QName _fail_on_error = new QName("fail-on-error");
    private static final QName c_line = new QName("c", "http://www.w3.org/ns/xproc-step", "line");
    private WritablePipe result = null;

    public Head(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        if (this.runtime.getSafeMode()) {
            throw XProcException.dynamicError(21);
        }
        boolean failOnError = this.getOption(_fail_on_error, true);
        int maxCount = this.getOption(_count, 10);
        RuntimeValue href = this.getOption(_href);
        URI uri = href.getBaseURI().resolve(href.getString());
        if (!"file".equals(uri.getScheme())) {
            throw new XProcException(this.step.getNode(), "Only file: scheme URIs are supported by the copy step.");
        }
        File file = new File(uri.getPath());
        if (!file.exists()) {
            throw new XProcException(this.step.getNode(), "Cannot read: file does not exist: " + file.getAbsolutePath());
        }
        if (file.isDirectory()) {
            throw new XProcException(this.step.getNode(), "Cannot read: file is a directory: " + file.getAbsolutePath());
        }
        TreeWriter tree = new TreeWriter(this.runtime);
        tree.startDocument(this.step.getNode().getBaseURI());
        tree.addStartElement(XProcConstants.c_result);
        tree.startContent();
        try {
            FileReader rdr = new FileReader(file);
            BufferedReader brdr = new BufferedReader(rdr);
            String line = null;
            int count = 0;
            if (maxCount >= 0) {
                line = brdr.readLine();
                while (line != null && count < maxCount) {
                    tree.addStartElement(c_line);
                    tree.startContent();
                    tree.addText(line);
                    tree.addEndElement();
                    tree.addText("\n");
                    ++count;
                    line = brdr.readLine();
                }
            } else {
                maxCount = -maxCount;
                line = "not null";
                while (line != null && count < maxCount) {
                    ++count;
                    line = brdr.readLine();
                }
                line = brdr.readLine();
                while (line != null) {
                    tree.addStartElement(c_line);
                    tree.startContent();
                    tree.addText(line);
                    tree.addEndElement();
                    tree.addText("\n");
                    line = brdr.readLine();
                }
            }
            brdr.close();
            rdr.close();
        }
        catch (FileNotFoundException fnfe) {
            throw new XProcException(fnfe);
        }
        catch (IOException ioe) {
            throw new XProcException(ioe);
        }
        tree.addEndElement();
        tree.endDocument();
        this.result.write(tree.getResult());
    }
}

