/*
 * Decompiled with CFR 0.152.
 */
package net.sqf.xsm.operations;

import net.sqf.xmlUtils.staxParser.ElementInfo;
import net.sqf.xmlUtils.staxParser.NodeInfo;
import net.sqf.xmlUtils.staxParser.PositionalXMLReader;
import net.sqf.xsm.operations.OperationsSet;
import net.sqf.xsm.operations.ReplaceOp;
import net.sqf.xsm.operations._Operation;
import org.w3c.dom.Node;

public class AddOp
implements _Operation {
    private final int start;
    private final int end;
    private final String replace;
    private final int prio;
    private final OperationsSet corrections = new OperationsSet();
    private String correctionId = "" + this.hashCode();

    public AddOp(Node context, String replace, String position, int prio, String correctionId) {
        this(context, replace, position, prio);
        this.correctionId = correctionId;
    }

    public AddOp(Node context, String replace, String position, int prio) {
        boolean contextIsEmpty;
        boolean addChild = position.equals("first-child") || position.equals("last-child");
        NodeInfo ni = PositionalXMLReader.getNodeInfo(context);
        boolean bl = contextIsEmpty = PositionalXMLReader.getPosition(context, "nils") == PositionalXMLReader.getPosition(context, "nle");
        if (addChild && contextIsEmpty && ni instanceof ElementInfo) {
            ElementInfo ei = (ElementInfo)ni;
            ReplaceOp startTag = new ReplaceOp(ei.getAttributRegionEndOffset(), ei.getInnerStartOffset(), ">", 1000, "openStartTag#" + context.hashCode());
            String prefix = context.getPrefix() == null ? "" : String.valueOf(context.getPrefix()) + ":";
            String qname = String.valueOf(prefix) + context.getLocalName();
            AddOp endTag = new AddOp(context, "</" + qname + ">", "after", 1000, "closeEndTag#" + context.hashCode());
            this.corrections.add(startTag);
            this.corrections.add(endTag);
        }
        this.end = this.start = AddOp.getStartByPosition(ni, position);
        this.replace = replace;
        this.prio = prio;
    }

    private static int getStartByPosition(NodeInfo info, String position) {
        if (position.equals("before")) {
            return info.getStartOffset();
        }
        if (position.equals("after")) {
            return info.getEndOffset();
        }
        if (info instanceof ElementInfo) {
            if (position.equals("first-child")) {
                return ((ElementInfo)info).getInnerStartOffset();
            }
            if (position.equals("last-child")) {
                return ((ElementInfo)info).getInnerEndOffset();
            }
            if (position.equals("attribute") || position.equals("@")) {
                return ((ElementInfo)info).getAttributRegionEndOffset();
            }
        }
        return info.getStartOffset();
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public String getReplace() {
        return this.replace;
    }

    @Override
    public int getPrio() {
        return this.prio;
    }

    public String toString() {
        return "[" + this.getStart() + ":" + this.getEnd() + "] " + this.getReplace();
    }

    @Override
    public OperationsSet getCorrectionOperations() {
        return this.corrections;
    }

    @Override
    public String getCorrectionId() {
        return this.correctionId;
    }
}

