/*
 * Decompiled with CFR 0.152.
 */
package net.sqf.xmlUtils.xslt;

import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sqf.stringUtils.TextSource;
import net.sqf.xmlUtils.exceptions.XSLTErrorListener;
import net.sqf.xmlUtils.xslt.Parameter;
import net.sqf.xmlUtils.xslt.SaxonUtils;

public class XSLTStep3 {
    private static TransformerFactory transfac;
    private static XSLTErrorListener factoryErrorListener;
    private final Transformer transformer;
    private XSLTErrorListener listener = new XSLTErrorListener();

    static {
        try {
            factoryErrorListener = new XSLTErrorListener();
            transfac = TransformerFactory.newInstance("net.sf.saxon.TransformerFactoryImpl", null);
            transfac.setErrorListener(factoryErrorListener);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public XSLTStep3(TextSource virtualXSL, XSLTErrorListener errorListener, ArrayList<Parameter> params) throws XSLTErrorListener {
        this(SaxonUtils.getStreamSource(virtualXSL), errorListener, params);
    }

    public XSLTStep3(File xslsheet, XSLTErrorListener errorListener, ArrayList<Parameter> params) throws XSLTErrorListener {
        this(SaxonUtils.getStreamSource(xslsheet), errorListener, params);
    }

    public XSLTStep3(Source xsl, XSLTErrorListener el, ArrayList<Parameter> params) throws XSLTErrorListener {
        this.listener = el;
        try {
            this.transformer = transfac.newTransformer(xsl);
        }
        catch (TransformerConfigurationException e) {
            try {
                this.listener.fatalError(e);
                this.listener.copyErrors(factoryErrorListener);
                factoryErrorListener.clear();
                throw this.listener;
            }
            catch (TransformerException e1) {
                throw factoryErrorListener;
            }
        }
        this.transformer.setErrorListener(el);
        this.transformer.setURIResolver(new URIResolver(){

            @Override
            public Source resolve(String arg0, String arg1) throws TransformerException {
                System.out.println(arg0);
                System.out.println(arg1);
                return null;
            }
        });
        this.setParameters(params);
    }

    public XSLTStep3(Source xslStream, ArrayList<Parameter> params) throws XSLTErrorListener {
        this(xslStream, new XSLTErrorListener(), params);
    }

    public XSLTStep3(TextSource virtualXSL, ArrayList<Parameter> params) throws XSLTErrorListener {
        this(virtualXSL, new XSLTErrorListener(), params);
    }

    public XSLTStep3(File xslsheet, ArrayList<Parameter> params) throws XSLTErrorListener {
        this(xslsheet, new XSLTErrorListener(), params);
    }

    public void setOutputProperty(Properties props) {
        this.transformer.setOutputProperties(props);
    }

    private void setParameters(ArrayList<Parameter> params) {
        for (Parameter p : params) {
            this.transformer.setParameter(p.getQName(), p.getValue());
        }
    }

    public TextSource transform(TextSource source, ArrayList<Parameter> params) {
        this.setParameters(params);
        return this.transform(source, source.getFile());
    }

    public TextSource transform(TextSource source) {
        return this.transform(source, source.getFile());
    }

    public TextSource transform(TextSource source, File outFile, ArrayList<Parameter> params) {
        this.setParameters(params);
        return this.transform(source, outFile);
    }

    public TextSource transform(TextSource source, File outFile) {
        StreamSource ss = new StreamSource(new StringReader(source.toString()));
        ss.setSystemId(source.getFile());
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        result.setSystemId(outFile.getAbsolutePath());
        this.transform(ss, result);
        TextSource resultSource = TextSource.createVirtualTextSource(outFile);
        resultSource.setData(writer.toString());
        return resultSource;
    }

    private Result transform(Source source, Result result) {
        try {
            this.transformer.transform(source, result);
        }
        catch (TransformerException e) {
            try {
                this.listener.error(e);
            }
            catch (TransformerException e1) {
                e1.printStackTrace();
            }
        }
        return result;
    }

    public ArrayList<TransformerException> getErrors(int level) {
        return this.listener.getErrors(level);
    }

    public ArrayList<TextSource> getSecondaryResults() {
        return new ArrayList<TextSource>();
    }
}

