/*
 * Decompiled with CFR 0.152.
 */
package net.sqf.xmlUtils.xslt;

import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.lib.OutputURIResolver;
import net.sqf.stringUtils.TextSource;
import net.sqf.xmlUtils.exceptions.XSLTErrorListener;
import net.sqf.xmlUtils.xslt.Parameter;
import net.sqf.xmlUtils.xslt.SaxonUtils;

public class XSLTStep {
    private static TransformerFactory transfac;
    private static XSLTErrorListener factoryErrorListener;
    private final Transformer transformer;
    private XSLTErrorListener listener = new XSLTErrorListener();
    private ArrayList<TextSource> secondaryResults = new ArrayList();

    static {
        try {
            factoryErrorListener = new XSLTErrorListener();
            transfac = TransformerFactory.newInstance("net.sf.saxon.TransformerFactoryImpl", null);
            transfac.setErrorListener(factoryErrorListener);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public XSLTStep(TextSource virtualXSL, XSLTErrorListener errorListener, ArrayList<Parameter> params) throws XSLTErrorListener {
        this(SaxonUtils.getStreamSource(virtualXSL), errorListener, params);
    }

    public XSLTStep(File xslsheet, XSLTErrorListener errorListener, ArrayList<Parameter> params) throws XSLTErrorListener {
        this(SaxonUtils.getStreamSource(xslsheet), errorListener, params);
    }

    public XSLTStep(Source xsl, XSLTErrorListener el, ArrayList<Parameter> params) throws XSLTErrorListener {
        this.listener = el;
        transfac.setAttribute("http://saxon.sf.net/feature/outputURIResolver", new OutputURIResolver(){
            private StringWriter writer;
            private File absFile;

            @Override
            public Result resolve(String href, String base) throws TransformerException {
                URI uri = URI.create(base);
                uri = uri.resolve(href);
                this.absFile = new File(uri);
                this.writer = new StringWriter();
                StreamResult result = new StreamResult(this.writer);
                result.setSystemId(this.absFile.toURI().toString());
                return result;
            }

            @Override
            public void close(Result result) throws TransformerException {
                TextSource resultSource = TextSource.createVirtualTextSource(this.absFile);
                resultSource.setData(this.writer.toString());
                XSLTStep.this.secondaryResults.add(resultSource);
            }

            @Override
            public OutputURIResolver newInstance() {
                return this;
            }
        });
        try {
            this.transformer = transfac.newTransformer(xsl);
        }
        catch (TransformerConfigurationException e) {
            try {
                this.listener.fatalError(e);
                this.listener.copyErrors(factoryErrorListener);
                factoryErrorListener.clear();
                throw this.listener;
            }
            catch (TransformerException e1) {
                throw factoryErrorListener;
            }
        }
        this.transformer.setErrorListener(el);
        if (TextSource.hasResolver()) {
            this.transformer.setURIResolver(TextSource.getResolver());
        }
        this.setParameters(params);
    }

    public XSLTStep(Source xslStream, ArrayList<Parameter> params) throws XSLTErrorListener {
        this(xslStream, new XSLTErrorListener(), params);
    }

    public XSLTStep(TextSource virtualXSL, ArrayList<Parameter> params) throws XSLTErrorListener {
        this(virtualXSL, new XSLTErrorListener(), params);
    }

    public XSLTStep(File xslsheet, ArrayList<Parameter> params) throws XSLTErrorListener {
        this(xslsheet, new XSLTErrorListener(), params);
    }

    public void setOutputProperty(Properties props) {
        this.transformer.setOutputProperties(props);
    }

    private void setParameters(ArrayList<Parameter> params) {
        for (Parameter p : params) {
            this.transformer.setParameter(p.getQName(), p.getValue());
        }
    }

    public TextSource transform(TextSource source, ArrayList<Parameter> params) {
        this.setParameters(params);
        return this.transform(source, source.getFile());
    }

    public TextSource transform(TextSource source) {
        return this.transform(source, source.getFile());
    }

    public TextSource transform(TextSource source, File outFile, ArrayList<Parameter> params) {
        this.setParameters(params);
        return this.transform(source, outFile);
    }

    public TextSource transform(TextSource source, File outFile) {
        StreamSource ss = new StreamSource(new StringReader(source.toString()));
        ss.setSystemId(source.getFile());
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        URI baseUri = new File(".").getAbsoluteFile().toURI();
        result.setSystemId(baseUri.resolve(outFile.toURI()).toString());
        this.transform(ss, result);
        TextSource resultSource = TextSource.createVirtualTextSource(outFile);
        resultSource.setData(writer.toString());
        return resultSource;
    }

    private Result transform(Source source, Result result) {
        try {
            this.transformer.transform(source, result);
        }
        catch (TransformerException e) {
            try {
                this.listener.error(e);
            }
            catch (TransformerException e1) {
                e1.printStackTrace();
            }
        }
        return result;
    }

    public ArrayList<TransformerException> getErrors(int level) {
        return this.listener.getErrors(level);
    }

    public ArrayList<TextSource> getSecondaryResults() {
        return this.secondaryResults;
    }
}

