/*
 * Decompiled with CFR 0.152.
 */
package net.sqf.xmlUtils.parser;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sqf.stringUtils.TextSource;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;

public class PositionalXMLHandler
extends DefaultHandler2 {
    private final Document doc;
    private String systemId = "";
    private final HashMap<Integer, Integer> linePositionMap;
    private final HashMap<String, String> prefixNamespaceMap = new HashMap();
    private final HashMap<String, String> namespacePrefixMap = new HashMap();
    private Locator locator;
    private final Stack<Element> elementStack = new Stack();
    private ArrayList<Node> textBuffer = new ArrayList();
    private final ArrayList<Node> allNodes = new ArrayList();
    private final HashMap<Integer, Node> positionNodeMap = new HashMap();
    private final byte[] docBytes;
    private int precLineNumber = 1;
    private int precColNumber = 0;
    private boolean parseLocalDTD = false;
    private Pattern attrPattern = Pattern.compile("\\s+(\\S+)(\\s+)?=(\\s+)?(\"([^\"]*)\"|'([^']*)')");

    public PositionalXMLHandler(Document docNode, String docString, HashMap<Integer, Integer> linePositionMap) {
        this.doc = docNode;
        this.docBytes = docString.getBytes();
        docNode.setUserData("hasDTD", false, null);
        this.linePositionMap = linePositionMap;
        this.prefixNamespaceMap.put("xml", "http://www.w3.org/XML/1998/namespace");
        this.namespacePrefixMap.put("http://www.w3.org/XML/1998/namespace", "xml");
    }

    protected HashMap<Integer, Node> positionNodeMap() {
        return this.positionNodeMap;
    }

    private int getPosition(int line, int col) {
        if (!this.linePositionMap.containsKey(line)) {
            return -1;
        }
        int linePos = this.linePositionMap.get(line);
        return linePos + col;
    }

    private int getLineNumber(int pos) {
        int i = 1;
        while (this.getPosition(i, 1) <= pos && this.getPosition(i + 1, 1) > 0) {
            ++i;
        }
        return i;
    }

    private int getColumn(int pos) {
        int line = this.getLineNumber(pos);
        return pos - this.linePositionMap.get(line);
    }

    @Override
    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) {
        try {
            URI dtdUri;
            if (baseURI != null) {
                URI base = new URI(baseURI);
                dtdUri = base.resolve(systemId);
            } else {
                dtdUri = new URI(systemId);
            }
            String dtdString = TextSource.readTextFile(dtdUri.toURL()).toString();
            StringReader strReader = new StringReader(dtdString);
            InputSource is = new InputSource(strReader);
            is.setPublicId(publicId);
            is.setSystemId(systemId);
            return is;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void endDTD() throws SAXException {
        super.endDTD();
        if (this.locator.getSystemId().equals(this.systemId)) {
            this.setUserData((Node)this.doc, 6);
        }
        this.parseLocalDTD = false;
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.parseLocalDTD = true;
        this.setUserData((Node)this.doc, 5);
        this.doc.setUserData("hasDTD", true, null);
        super.startDTD(name, publicId, systemId);
    }

    @Override
    public void attributeDecl(String eName, String aName, String type, String mode, String value) throws SAXException {
        super.attributeDecl(eName, aName, type, mode, value);
    }

    @Override
    public void elementDecl(String name, String model) throws SAXException {
        super.elementDecl(name, model);
    }

    @Override
    public void endEntity(String name) throws SAXException {
        super.endEntity(name);
    }

    @Override
    public void endCDATA() throws SAXException {
        super.endCDATA();
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        super.endPrefixMapping(prefix);
    }

    @Override
    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
        super.externalEntityDecl(name, publicId, systemId);
    }

    @Override
    public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
        return super.getExternalSubset(name, baseURI);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        String appendText = new String(ch, start, length);
        Text textNode = this.doc.createTextNode(appendText);
        this.textBuffer.add(textNode);
        this.setUserData((Node)textNode, 4);
    }

    @Override
    public void internalEntityDecl(String name, String value) throws SAXException {
        super.internalEntityDecl(name, value);
    }

    @Override
    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        super.notationDecl(name, publicId, systemId);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        super.skippedEntity(name);
    }

    @Override
    public void startCDATA() throws SAXException {
        super.startCDATA();
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
    }

    @Override
    public void startEntity(String name) throws SAXException {
        super.startEntity(name);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.prefixNamespaceMap.put(prefix, uri);
        this.namespacePrefixMap.put(uri, prefix);
        super.startPrefixMapping(prefix, uri);
    }

    @Override
    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        super.unparsedEntityDecl(name, publicId, systemId, notationName);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        return new InputSource(new ByteArrayInputStream(new byte[0]));
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        if ("".equals(this.systemId)) {
            this.systemId = locator.getSystemId();
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.addTextIfNeeded();
        Element el = this.doc.createElementNS(uri, localName);
        el.setPrefix(this.namespacePrefixMap.get(uri));
        el.setUserData("prefixMapping", this.prefixNamespaceMap.clone(), null);
        el.setUserData("namespaceMapping", this.namespacePrefixMap.clone(), null);
        this.setUserData((Node)el, 1);
        int i = 0;
        while (i < attributes.getLength()) {
            String attrName = attributes.getQName(i);
            String ns = attributes.getURI(i);
            if (ns.equals("")) {
                el.setAttribute(attrName, attributes.getValue(i));
            } else {
                el.setAttributeNS(ns, attrName, attributes.getValue(i));
            }
            Attr attrNode = el.getAttributeNode(attrName);
            this.setUserData((Node)el, attrNode);
            ++i;
        }
        this.setAttributeRegion(el);
        this.elementStack.push(el);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        this.addTextIfNeeded();
        Element closedEl = this.elementStack.pop();
        this.setUserData((Node)closedEl, 2);
        if (this.elementStack.isEmpty()) {
            this.doc.appendChild(closedEl);
        } else {
            Element parentEl = this.elementStack.peek();
            parentEl.appendChild(closedEl);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String appendText = new String(ch, start, length);
        Text textNode = this.doc.createTextNode(appendText);
        this.textBuffer.add(textNode);
        this.setUserData((Node)textNode, 4);
    }

    @Override
    public void processingInstruction(String target, String data) {
        this.addTextIfNeeded();
        if (this.systemId.equals(this.locator.getSystemId()) && !this.parseLocalDTD) {
            Document el = this.elementStack.isEmpty() ? this.doc : (Node)this.elementStack.peek();
            ProcessingInstruction pi = this.doc.createProcessingInstruction(target, data);
            el.appendChild(pi);
            this.setUserData(pi);
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) {
        this.addTextIfNeeded();
        if (this.systemId.equals(this.locator.getSystemId()) && !this.parseLocalDTD) {
            Document el = this.elementStack.isEmpty() ? this.doc : (Node)this.elementStack.peek();
            String comment = new String(ch, start, length);
            Comment commentNode = this.doc.createComment(comment);
            el.appendChild(commentNode);
            this.setUserData(commentNode);
        }
    }

    private void addTextIfNeeded() {
        if (this.textBuffer.size() > 0) {
            String textBuffer = "";
            for (Node textNode : this.textBuffer) {
                textBuffer = String.valueOf(textBuffer) + textNode.getNodeValue();
            }
            Node el = this.elementStack.peek();
            Text newTextNode = this.doc.createTextNode(textBuffer);
            Node first = this.textBuffer.get(0);
            Node last = this.textBuffer.get(this.textBuffer.size() - 1);
            newTextNode.setUserData("lineNumber", first.getUserData("lineNumber"), null);
            newTextNode.setUserData("columnNumber", first.getUserData("columnNumber"), null);
            newTextNode.setUserData("positionStart", first.getUserData("positionStart"), null);
            newTextNode.setUserData("lineNumberLast", last.getUserData("lineNumberLast"), null);
            newTextNode.setUserData("columnNumberLast", last.getUserData("columnNumberLast"), null);
            newTextNode.setUserData("positionEnd", last.getUserData("positionEnd"), null);
            el.appendChild(newTextNode);
            this.textBuffer = new ArrayList();
        }
    }

    private void setUserData(Node el, Attr at) {
        this.allNodes.add(at);
        int startPos = (Integer)el.getUserData("positionStart");
        int endPos = (Integer)el.getUserData("positionInner");
        String startTag = new String(this.docBytes, startPos, endPos - startPos);
        Matcher matcher = this.attrPattern.matcher(startTag);
        while (matcher.find()) {
            String name = matcher.group(1);
            if (!name.equals(at.getName())) continue;
            MatchResult mresult = matcher.toMatchResult();
            endPos -= startTag.length() - mresult.end();
            at.setUserData("positionStart", startPos += mresult.start(), null);
            at.setUserData("lineNumber", this.getLineNumber(startPos), null);
            at.setUserData("columnNumber", this.getColumn(startPos), null);
            at.setUserData("positionEnd", endPos, null);
            at.setUserData("lineNumberLast", this.getLineNumber(endPos), null);
            at.setUserData("columnNumberLast", this.getColumn(endPos), null);
            break;
        }
    }

    private void setAttributeRegion(Node el) {
        Pattern patternEnd;
        Matcher matcherEnd;
        int startPos = (Integer)el.getUserData("positionStart");
        int endPos = (Integer)el.getUserData("positionInner");
        String startTag = new String(this.docBytes, startPos, endPos - startPos);
        Pattern patternStart = Pattern.compile("\\s");
        Matcher matcherStart = patternStart.matcher(startTag);
        el.setUserData("attributeRegionStart", startPos += matcherStart.find() ? matcherStart.start() : (endPos -= (matcherEnd = (patternEnd = Pattern.compile("(/)?>$", 32)).matcher(startTag)).find() ? startTag.length() - matcherEnd.start() : endPos - 1) - startPos, null);
        el.setUserData("attributeRegionEnd", endPos, null);
    }

    private void setUserData(Node node) {
        this.setUserData(node, 0);
    }

    private void setUserData(Node node, int type) {
        String[] lastKeys;
        String[] firstKeys;
        if (node.getNodeType() == 9 && !node.equals(this.doc)) {
            return;
        }
        int lineNumber = this.precLineNumber;
        int colNumber = this.precColNumber;
        int pos = this.getPosition(lineNumber, colNumber);
        int lastLineNumber = this.locator.getLineNumber();
        int lastColNumber = this.locator.getColumnNumber() - 1;
        int lastPos = this.getPosition(lastLineNumber, lastColNumber);
        String startTag = new String(this.docBytes, pos, lastPos - pos);
        if (this.elementStack.isEmpty() && (type == 0 || type == 1)) {
            int corr;
            String passage = new String(this.docBytes, pos, lastPos - pos);
            if (pos == 0 && passage.contains("<?xml")) {
                int endXMlDel = passage.indexOf("?>") + 2;
                passage = passage.substring(endXMlDel);
                pos += endXMlDel;
            }
            if (node.getNodeType() == 8) {
                corr = passage.indexOf("<!--");
                pos += corr;
                passage = passage.substring(corr);
            } else if (node.getNodeType() == 7) {
                corr = passage.indexOf("<?");
                pos += corr;
                passage = passage.substring(corr);
            } else if (type == 1) {
                corr = passage.indexOf("<");
                pos += corr;
            }
        }
        if (type == 0 || type == 4) {
            firstKeys = new String[]{"lineNumber", "columnNumber", "positionStart"};
            lastKeys = new String[]{"lineNumberLast", "columnNumberLast", "positionEnd"};
        } else if (type == 1) {
            firstKeys = new String[]{"lineNumber", "columnNumber", "positionStart"};
            lastKeys = new String[]{"innerLineNumber", "innerColumnNumber", "positionInner"};
        } else if (type == 2) {
            firstKeys = new String[]{"innerLineNumberLast", "innerColumnNumberLast", "positionInnerLast"};
            lastKeys = new String[]{"lineNumberLast", "columnNumberLast", "positionEnd"};
        } else if (type == 5) {
            firstKeys = new String[]{"dtdLineNumber", "dtdColumnNumber", "dtdPositionStart"};
            lastKeys = new String[]{"dtdLineNumberLast", "dtdColumnNumberLast", "dtdPositionEnd"};
        } else if (type == 6) {
            firstKeys = new String[]{"", "", ""};
            lastKeys = new String[]{"dtdLineNumberLast", "dtdColumnNumberLast", "dtdPositionEnd"};
        } else {
            firstKeys = new String[]{"", "", ""};
            lastKeys = new String[]{"", "", ""};
        }
        if (type != 6) {
            node.setUserData(firstKeys[0], lineNumber, null);
            node.setUserData(firstKeys[1], colNumber, null);
            node.setUserData(firstKeys[2], pos, null);
        }
        node.setUserData(lastKeys[0], lastLineNumber, null);
        node.setUserData(lastKeys[1], lastColNumber, null);
        node.setUserData(lastKeys[2], lastPos, null);
        this.precLineNumber = lastLineNumber;
        this.precColNumber = lastColNumber;
        if (type != 5 && type != 6) {
            this.allNodes.add(node);
        }
        this.positionNodeMap.put(lastPos, node);
    }
}

