/*
 * Decompiled with CFR 0.152.
 */
package net.sqf.utils.process.queues;

import java.util.ArrayList;
import net.sqf.utils.process.log.DefaultProcessStateListener;
import net.sqf.utils.process.log.ProcessStateListener;
import net.sqf.utils.process.queues.Task;
import net.sqf.utils.process.queues.listeners.QueueEndListener;
import net.sqf.utils.process.queues.listeners.QueueListener;

public class SimpleQueue<IOType>
implements QueueListener<IOType> {
    private ArrayList<Task<IOType>> tasks = new ArrayList();
    private ProcessStateListener psl = new DefaultProcessStateListener();
    private final String description;
    private ArrayList<Exception> exceptions = new ArrayList();
    private ArrayList<IOType> tempResults = new ArrayList();
    private Task<IOType> currentTask;
    private ArrayList<QueueEndListener<IOType>> endListener = new ArrayList();
    private final ArrayList<QueueListener<IOType>> cancelListener = new ArrayList();

    public SimpleQueue(String description, ProcessStateListener psl) {
        this.description = description;
        if (psl != null) {
            this.psl = psl;
        }
    }

    public void addTask(Task<IOType> task) {
        this.tasks.add(task);
    }

    public void addTask(ArrayList<Task<IOType>> tasks) {
        this.tasks.addAll(tasks);
    }

    public void start(IOType input) {
        this.exceptions = new ArrayList();
        this.tempResults = new ArrayList();
        this.tempResults.add(input);
        for (Task<IOType> task : this.tasks) {
            task.addCancelListener(this);
            task.addEndListener(this);
            task.addStartListener(this);
        }
        this.tasks.get(0).start(input);
    }

    public IOType get() throws Exception {
        if (this.isCanceled()) {
            throw this.exceptions.get(0);
        }
        return (IOType)this.tasks.get(this.tasks.size() - 1).get();
    }

    @Override
    public void processCancel(Task<IOType> currentTask, Exception e) {
        this.exceptions.add(e);
        this.psl.end(e);
        this.cancel(e);
    }

    @Override
    public void processStart(Task<IOType> currentTask) {
        this.currentTask = currentTask;
        this.psl.setProcessState(this.getProgress(), currentTask.toString());
    }

    private int getTaskIndex(Task<IOType> currentTask) {
        return this.tasks.indexOf(currentTask);
    }

    private double getProgress() {
        return ((double)this.getTaskIndex(this.currentTask) + 0.0) / (double)this.tasks.size();
    }

    @Override
    public void processEnd(Task<IOType> currentTask) {
        int i = this.getTaskIndex(currentTask);
        if (!this.isCanceled()) {
            if (i + 1 < this.tasks.size()) {
                Task nextTask = this.tasks.get(i + 1);
                try {
                    Object temp = currentTask.get();
                    this.tempResults.add(temp);
                    nextTask.start(temp);
                }
                catch (Exception e) {
                    nextTask.cancel(e);
                }
            } else {
                try {
                    this.tempResults.add(currentTask.get());
                    this.psl.setProcessState(1.0, this.toString());
                    this.processEndListener();
                    this.psl.end();
                }
                catch (Exception e) {
                    this.processCancel(currentTask, e);
                }
            }
        }
    }

    public ArrayList<IOType> getTempResults() {
        return this.tempResults;
    }

    private boolean isCanceled() {
        return this.exceptions.size() > 0;
    }

    public void addCancelListener(QueueListener<IOType> listener) {
        this.cancelListener.add(listener);
    }

    protected void cancel(Exception e) {
        for (QueueListener<IOType> lis : this.cancelListener) {
            lis.processCancel(this.currentTask, e);
        }
    }

    public void addEndListener(QueueEndListener<IOType> listener) {
        this.endListener.add(listener);
    }

    private void processEndListener() {
        for (QueueEndListener<IOType> lis : this.endListener) {
            try {
                lis.finish(this.get());
            }
            catch (Exception e) {
                this.cancel(e);
            }
        }
    }

    public String toString() {
        return this.description;
    }
}

