/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver.tools;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;
import org.xmlresolver.Catalog;
import org.xmlresolver.Resolver;
import org.xmlresolver.helpers.FileURI;

public class ResolvingXMLFilter
extends XMLFilterImpl {
    private boolean allowXMLCatalogPI = false;
    private boolean oasisXMLCatalogPI = false;
    private Resolver resolver = new Resolver();
    private URL baseURL = null;

    public ResolvingXMLFilter() {
    }

    public ResolvingXMLFilter(Resolver resolver) {
        this.resolver = resolver;
    }

    public ResolvingXMLFilter(XMLReader parent, Resolver resolver) {
        super(parent);
        this.resolver = resolver;
    }

    public Resolver getResolver() {
        return this.resolver;
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        this.allowXMLCatalogPI = true;
        this.setupBaseURI(input.getSystemId());
        super.parse(input);
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        this.allowXMLCatalogPI = true;
        this.setupBaseURI(systemId);
        super.parse(systemId);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        this.allowXMLCatalogPI = false;
        return this.resolver.resolveEntity(publicId, systemId);
    }

    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
        this.allowXMLCatalogPI = false;
        return this.resolver.resolveEntity(name, publicId, baseURI, systemId);
    }

    @Override
    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        this.allowXMLCatalogPI = false;
        super.notationDecl(name, publicId, systemId);
    }

    @Override
    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        this.allowXMLCatalogPI = false;
        super.unparsedEntityDecl(name, publicId, systemId, notationName);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.allowXMLCatalogPI = false;
        super.startElement(uri, localName, qName, atts);
    }

    @Override
    public void processingInstruction(String target, String pidata) throws SAXException {
        if (this.allowXMLCatalogPI && target.equals("oasis-xml-catalog")) {
            URL catalog = null;
            String data = pidata;
            int pos = data.indexOf("catalog=");
            if (pos >= 0 && (data = data.substring(pos + 8)).length() > 1) {
                String quote = data.substring(0, 1);
                pos = (data = data.substring(1)).indexOf(quote);
                if (pos >= 0) {
                    data = data.substring(0, pos);
                    try {
                        catalog = this.baseURL != null ? new URL(this.baseURL, data) : new URL(data);
                        Catalog newCatalog = new Catalog(this.resolver.getCatalog().catalogList() + ";" + catalog.toString());
                        this.resolver = new Resolver(newCatalog);
                    }
                    catch (MalformedURLException mue) {}
                }
            }
        } else {
            super.processingInstruction(target, pidata);
        }
    }

    private void setupBaseURI(String systemId) {
        URL cwd = null;
        try {
            cwd = FileURI.makeURI("basename").toURL();
        }
        catch (MalformedURLException mue) {
            cwd = null;
        }
        try {
            this.baseURL = new URL(systemId);
        }
        catch (MalformedURLException mue) {
            if (cwd != null) {
                try {
                    this.baseURL = new URL(cwd, systemId);
                }
                catch (MalformedURLException mue2) {
                    this.baseURL = null;
                }
            }
            this.baseURL = null;
        }
    }
}

