/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver;

import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmlresolver.CatalogResult;
import org.xmlresolver.CatalogSource;
import org.xmlresolver.Configuration;
import org.xmlresolver.ResourceCache;
import org.xmlresolver.helpers.DOMUtils;
import org.xmlresolver.helpers.PublicId;
import org.xmlresolver.helpers.URIUtils;

public class Catalog {
    public static final String NS_CATALOG = "urn:oasis:names:tc:entity:xmlns:xml:catalog";
    public static final String NS_RDDL = "http://www.rddl.org/";
    public static final String NS_XLINK = "http://www.w3.org/1999/xlink";
    public static final String NS_XMLRESOURCE_EXT = "http://xmlresolver.org/ns/catalog";
    public static Logger logger = Logger.getLogger("org.xmlresolver");
    private Configuration conf;
    private Vector<CatalogSource> catalogList = new Vector();
    private Vector<Document> documentList = new Vector();
    private ResourceCache cache = null;

    private static String defaultPropertiesFiles() {
        String propfile = System.getProperty("xmlresolver.properties");
        return (propfile != null ? propfile + ";" : "") + "XMLResolver.properties;CatalogManager.properties";
    }

    public Catalog() {
        this(Catalog.defaultPropertiesFiles(), (String)null);
    }

    public Catalog(String catalogList) {
        this(Catalog.defaultPropertiesFiles(), catalogList);
    }

    public Catalog(String propertyFileList, String catalogList) {
        this(Configuration.create(propertyFileList), catalogList);
    }

    public Catalog(Configuration conf, String catalogList) {
        this(conf, Catalog.createSources(conf, catalogList));
    }

    public Catalog(Configuration conf, Vector<CatalogSource> catalogList) {
        this.conf = conf;
        this.catalogList = catalogList;
        this.setCacheDir(conf.queryCache());
    }

    public final void setCacheDir(String cacheDir) {
        this.cache = cacheDir != null && !cacheDir.equals("") ? new ResourceCache(cacheDir) : null;
    }

    public String catalogList() {
        String list = "";
        for (CatalogSource catalog : this.catalogList) {
            if (list.length() > 0) {
                list = list + ";";
            }
            list = list + catalog;
        }
        return list;
    }

    public ResourceCache cache() {
        return this.cache;
    }

    public boolean cacheSchemeURI(String scheme) {
        return this.conf.queryCacheSchemeURI(scheme);
    }

    private synchronized Document loadCatalog(int index) {
        Element root;
        if (index < this.documentList.size()) {
            return this.documentList.get(index);
        }
        CatalogSource catalog = this.catalogList.get(index);
        Document doc = catalog.parse();
        while (this.documentList.size() <= index) {
            this.documentList.add(null);
        }
        this.documentList.set(index, doc);
        int offset = 1;
        if (doc != null && this.catalogElement(root = doc.getDocumentElement(), "catalog")) {
            Element child = DOMUtils.getFirstElement(root);
            while (child != null) {
                if (this.catalogElement(child, "nextCatalog")) {
                    Element nextCat = child;
                    String nextCatalog = DOMUtils.makeAbsolute(nextCat, nextCat.getAttribute("catalog"));
                    logger.finer("Next catalog: " + nextCat.getAttribute("catalog") + " (" + nextCatalog + ")");
                    if (index + offset >= this.catalogList.size()) {
                        this.catalogList.add(new CatalogSource.UriCatalogSource(nextCatalog));
                    } else {
                        this.catalogList.insertElementAt(new CatalogSource.UriCatalogSource(nextCatalog), index + offset);
                    }
                    ++offset;
                }
                child = DOMUtils.getNextElement(child);
            }
        }
        return doc;
    }

    private boolean catalogElement(Node node, String localName) {
        return node.getNodeType() == 1 && localName.equals(node.getLocalName()) && NS_CATALOG.equals(node.getNamespaceURI());
    }

    private Vector<Element> entries(Element group, String entry) {
        Vector<Element> matchingEntries = new Vector<Element>();
        this.findMatches(matchingEntries, group, entry, null, null, null, null);
        return matchingEntries;
    }

    private Vector<Element> entries(Element group, String entry, String attr, String value, String nature, String purpose) {
        Vector<Element> matchingEntries = new Vector<Element>();
        this.findMatches(matchingEntries, group, entry, attr, value, nature, purpose);
        return matchingEntries;
    }

    private void findMatches(Vector<Element> matching, Element group, String entry, String attr, String value, String nature, String purpose) {
        if (this.catalogElement(group, "group") || this.catalogElement(group, "catalog")) {
            Element child = DOMUtils.getFirstElement(group);
            while (child != null) {
                if (this.catalogElement(child, entry) && (attr == null || value.equals(child.getAttribute(attr)))) {
                    String uriPurpose;
                    String uriNature = child.hasAttributeNS(NS_RDDL, "nature") ? child.getAttributeNS(NS_RDDL, "nature") : null;
                    String string = uriPurpose = child.hasAttributeNS(NS_RDDL, "purpose") ? child.getAttributeNS(NS_RDDL, "purpose") : null;
                    if ((nature == null || nature.equals(uriNature)) && (purpose == null || purpose.equals(uriPurpose))) {
                        matching.add(child);
                    }
                }
                if (this.catalogElement(child, "group")) {
                    this.findMatches(matching, child, entry, attr, value, nature, purpose);
                }
                child = DOMUtils.getNextElement(child);
            }
        }
    }

    public CatalogResult lookupURI(String uri) {
        logger.finer("lookupURI(" + uri + ")");
        return this._lookupNamespaceURI(uri, null, null);
    }

    public CatalogResult lookupNamespaceURI(String uri, String nature, String purpose) {
        logger.finer("lookupNamespaceURI(" + uri + "," + nature + "," + purpose + ")");
        return this._lookupNamespaceURI(uri, nature, purpose);
    }

    private CatalogResult _lookupNamespaceURI(String uri, String nature, String purpose) {
        if (uri == null) {
            throw new NullPointerException("Null uri passed to Catalog.");
        }
        if ((uri = URIUtils.normalizeURI(uri)).startsWith("urn:publicid:")) {
            return this.lookupPublic(PublicId.decodeURN(uri), null);
        }
        for (int index = 0; index < this.catalogList.size(); ++index) {
            this.loadCatalog(index);
            Document doc = this.documentList.get(index);
            if (doc == null) continue;
            logger.finer("  Looking in catalog: " + doc.getBaseURI());
            CatalogResult resolved = this.lookupURI(doc.getDocumentElement(), uri, nature, purpose);
            if (resolved == null) continue;
            logger.finer("  Found: " + resolved);
            return resolved;
        }
        if (this.cache != null && this.cache.catalog() != null) {
            logger.finer("  Looking in cache: " + this.cache.catalog().getBaseURI());
            CatalogResult resolved = this.lookupURI(this.cache.catalog().getDocumentElement(), uri, nature, purpose);
            if (resolved != null) {
                logger.finer("  Found: " + resolved);
                return resolved;
            }
        }
        logger.finer("  Not found");
        return null;
    }

    protected CatalogResult lookupURI(Element group, String uri, String nature, String purpose) {
        Iterator<Element> i$ = this.entries(group, "uri", "name", uri, nature, purpose).iterator();
        if (i$.hasNext()) {
            Element child = i$.next();
            String entry_uri = child.getAttribute("uri");
            String entry_name = child.getAttribute("name");
            String entry_redir = null;
            if (child.hasAttributeNS(NS_XMLRESOURCE_EXT, "redir")) {
                entry_redir = child.getAttributeNS(NS_XMLRESOURCE_EXT, "redir");
            }
            return new CatalogResult(entry_redir == null ? entry_name : entry_redir, DOMUtils.makeAbsolute(child, entry_uri), child, this.cache);
        }
        String startString = null;
        Element node = null;
        for (Element child : this.entries(group, "rewriteURI", null, uri, nature, purpose)) {
            String p = child.getAttribute("uriStartString");
            if (p.length() > uri.length() || !p.equals(uri.substring(0, p.length())) || startString != null && p.length() <= startString.length()) continue;
            startString = p;
            node = child;
        }
        if (node != null) {
            return new CatalogResult(uri, DOMUtils.makeAbsolute(node, node.getAttribute("rewritePrefix") + uri.substring(startString.length())), node, this.cache);
        }
        String suffixString = null;
        node = null;
        for (Element child : this.entries(group, "uriSuffix", null, uri, nature, purpose)) {
            String p = child.getAttribute("uriSuffix");
            if (p.length() > uri.length() || !uri.endsWith(p) || suffixString != null && p.length() <= suffixString.length()) continue;
            suffixString = p;
            node = child;
        }
        if (node != null) {
            return new CatalogResult(uri, DOMUtils.makeAbsolute(node, node.getAttribute("uri")), node, this.cache);
        }
        Vector<String> delegated = new Vector<String>();
        for (Element child : this.entries(group, "delegateURI", null, uri, nature, purpose)) {
            String p = child.getAttribute("uriStartString");
            if (p.length() > uri.length() || !p.equals(uri.substring(0, p.length()))) continue;
            delegated.add(DOMUtils.makeAbsolute(child, child.getAttribute("catalog")));
        }
        if (!delegated.isEmpty()) {
            Catalog dResolver = new Catalog(this.conf, Catalog.toCatalogSources(delegated));
            CatalogResult resolved = null;
            resolved = nature != null || purpose != null ? dResolver.lookupNamespaceURI(uri, nature, purpose) : dResolver.lookupURI(uri);
            return resolved;
        }
        return null;
    }

    public CatalogResult lookupPublic(String systemId, String publicId) {
        logger.finer("lookupPublic(" + systemId + "," + publicId + ")");
        if (systemId != null) {
            systemId = URIUtils.normalizeURI(systemId);
        }
        if (publicId != null && publicId.startsWith("urn:publicid:")) {
            publicId = PublicId.decodeURN(publicId);
        }
        if (systemId != null && systemId.startsWith("urn:publicid:")) {
            systemId = PublicId.decodeURN(systemId);
            if (publicId != null && !publicId.equals(systemId)) {
                logger.warning("urn:publicid: system identifier differs from public identifier; using public identifier");
                systemId = null;
            } else {
                publicId = systemId;
                systemId = null;
            }
        }
        for (int index = 0; index < this.catalogList.size(); ++index) {
            this.loadCatalog(index);
            Document doc = this.documentList.get(index);
            if (doc == null) continue;
            logger.finer("  Looking in " + doc.getBaseURI());
            CatalogResult resolved = this.lookupPublic(doc.getDocumentElement(), systemId, publicId);
            if (resolved == null) continue;
            logger.finer("  Found: " + resolved);
            return resolved;
        }
        if (this.cache != null && this.cache.catalog() != null) {
            logger.finer("  Looking in " + this.cache.catalog().getBaseURI());
            CatalogResult resolved = this.lookupPublic(this.cache.catalog().getDocumentElement(), systemId, publicId);
            if (resolved != null) {
                logger.finer("  Found: " + resolved);
                return resolved;
            }
        }
        logger.finer("  Not found");
        return null;
    }

    protected CatalogResult lookupPublic(Element group, String systemId, String publicId) {
        if (this.catalogElement(group, "group") || this.catalogElement(group, "catalog")) {
            CatalogResult resolved;
            if (systemId != null && (resolved = this.lookupLocalSystem(group, systemId)) != null) {
                return resolved;
            }
            if (publicId != null && (resolved = this.lookupLocalPublic(group, systemId, publicId)) != null) {
                return resolved;
            }
        }
        return null;
    }

    protected CatalogResult lookupLocalPublic(Element group, String systemId, String publicId) {
        CatalogResult resolved;
        publicId = PublicId.normalize(publicId);
        if (systemId != null && (resolved = this.lookupLocalSystem(group, systemId)) != null) {
            return resolved;
        }
        for (Element child : this.entries(group, "public", "publicId", publicId, null, null)) {
            boolean preferpublic = this.conf.queryPreferPublic();
            Node node = child;
            while (node != null && node.getNodeType() == 1) {
                Element p = node;
                if (p.hasAttribute("prefer")) {
                    preferpublic = "public".equals(p.getAttribute("prefer"));
                    node = null;
                    continue;
                }
                node = node.getParentNode();
            }
            if (!preferpublic && systemId != null) continue;
            String localURI = DOMUtils.makeAbsolute(child, child.getAttribute("uri"));
            String origURI = systemId;
            if (origURI == null) {
                origURI = localURI;
            }
            return new CatalogResult(origURI, localURI, child, this.cache);
        }
        Vector<String> delegated = new Vector<String>();
        for (Element child : this.entries(group, "delegatePublic", null, null, null, null)) {
            String p = child.getAttribute("publicIdStartString");
            if (p.length() > systemId.length() || !p.equals(systemId.substring(0, p.length()))) continue;
            delegated.add(DOMUtils.makeAbsolute(child, child.getAttribute("catalog")));
        }
        if (!delegated.isEmpty()) {
            Catalog dResolver = new Catalog(this.conf, Catalog.toCatalogSources(delegated));
            CatalogResult resolved2 = dResolver.lookupSystem(systemId);
            return resolved2;
        }
        return null;
    }

    public CatalogResult lookupSystem(String systemId) {
        logger.finer("lookupSystem(" + systemId + ")");
        systemId = URIUtils.normalizeURI(systemId);
        if (systemId != null && systemId.startsWith("urn:publicid:")) {
            return this.lookupPublic(PublicId.decodeURN(systemId), null);
        }
        for (int index = 0; index < this.catalogList.size(); ++index) {
            this.loadCatalog(index);
            Document doc = this.documentList.get(index);
            if (doc == null) continue;
            logger.finer("  Looking in " + doc.getBaseURI());
            CatalogResult resolved = this.lookupLocalSystem(doc.getDocumentElement(), systemId);
            if (resolved == null) continue;
            logger.finer("  Found: " + resolved);
            return resolved;
        }
        if (this.cache != null && this.cache.catalog() != null) {
            logger.finer("  Looking in " + this.cache.catalog().getBaseURI());
            CatalogResult resolved = this.lookupLocalSystem(this.cache.catalog().getDocumentElement(), systemId);
            if (resolved != null) {
                logger.finer("  Found: " + resolved);
                return resolved;
            }
        }
        logger.finer("  Not found");
        return null;
    }

    protected CatalogResult lookupLocalSystem(Element group, String systemId) {
        String osname = System.getProperty("os.name");
        boolean windows = osname.indexOf("Windows") >= 0;
        for (Element child : this.entries(group, "system", null, null, null, null)) {
            if (!systemId.equals(child.getAttribute("systemId")) && (!windows || !systemId.equalsIgnoreCase(child.getAttribute("systemId")))) continue;
            return new CatalogResult(systemId, DOMUtils.makeAbsolute(child, child.getAttribute("uri")), child, this.cache);
        }
        String startString = null;
        Element node = null;
        for (Element child : this.entries(group, "rewriteSystem", null, null, null, null)) {
            String p = child.getAttribute("uriStartString");
            if (p.length() > systemId.length() || !p.equals(systemId.substring(0, p.length())) || startString != null && p.length() <= startString.length()) continue;
            startString = p;
            node = child;
        }
        if (node != null) {
            return new CatalogResult(systemId, DOMUtils.makeAbsolute(node, node.getAttribute("rewritePrefix") + systemId.substring(startString.length())), node, this.cache);
        }
        String suffixString = null;
        node = null;
        for (Element child : this.entries(group, "systemSuffix", null, null, null, null)) {
            String p = child.getAttribute("systemIdSuffix");
            if (p.length() > systemId.length() || !systemId.endsWith(p) || suffixString != null && p.length() <= suffixString.length()) continue;
            suffixString = p;
            node = child;
        }
        if (node != null) {
            return new CatalogResult(systemId, DOMUtils.makeAbsolute(node, node.getAttribute("uri")), node, this.cache);
        }
        Vector<String> delegated = new Vector<String>();
        for (Element child : this.entries(group, "delegateSystem", null, null, null, null)) {
            String p = child.getAttribute("systemIdStartString");
            if (p.length() > systemId.length() || !p.equals(systemId.substring(0, p.length()))) continue;
            delegated.add(DOMUtils.makeAbsolute(child, child.getAttribute("catalog")));
        }
        if (!delegated.isEmpty()) {
            Catalog dResolver = new Catalog(this.conf, Catalog.toCatalogSources(delegated));
            CatalogResult resolved = dResolver.lookupSystem(systemId);
            return resolved;
        }
        return null;
    }

    public CatalogResult lookupDoctype(String entityName, String systemId, String publicId) {
        logger.finer("lookupDoctype(" + entityName + "," + publicId + "," + systemId + ")");
        systemId = URIUtils.normalizeURI(systemId);
        if (publicId != null && publicId.startsWith("urn:publicid:")) {
            publicId = PublicId.decodeURN(publicId);
        }
        if (systemId != null && systemId.startsWith("urn:publicid:")) {
            systemId = PublicId.decodeURN(systemId);
            if (publicId != null && !publicId.equals(systemId)) {
                logger.warning("urn:publicid: system identifier differs from public identifier; using public identifier");
                systemId = null;
            } else {
                publicId = systemId;
                systemId = null;
            }
        }
        for (int index = 0; index < this.catalogList.size(); ++index) {
            this.loadCatalog(index);
            Document doc = this.documentList.get(index);
            if (doc == null) continue;
            logger.finer("  Looking in " + doc.getBaseURI());
            CatalogResult resolved = this.lookupDoctype(doc.getDocumentElement(), entityName, systemId, publicId);
            if (resolved == null) continue;
            logger.finer("  Found: " + resolved);
            return resolved;
        }
        logger.finer("  Not found");
        return null;
    }

    protected CatalogResult lookupDoctype(Element group, String entityName, String systemId, String publicId) {
        CatalogResult resolved = null;
        if (systemId != null && (resolved = this.lookupLocalSystem(group, systemId)) != null) {
            return resolved;
        }
        if (publicId != null && (resolved = this.lookupLocalPublic(group, systemId, publicId)) != null) {
            return resolved;
        }
        for (Element child : this.entries(group, "doctype", "name", entityName, null, null)) {
            boolean preferpublic = this.conf.queryPreferPublic();
            Node node = child;
            while (node != null && node.getNodeType() == 1) {
                Element p = node;
                if (p.hasAttribute("prefer")) {
                    preferpublic = "public".equals(p.getAttribute("prefer"));
                    node = null;
                    continue;
                }
                node = node.getParentNode();
            }
            if (!preferpublic && systemId != null) continue;
            String localURI = DOMUtils.makeAbsolute(child, child.getAttribute("uri"));
            String origURI = systemId;
            if (origURI == null) {
                origURI = localURI;
            }
            return new CatalogResult(origURI, localURI, child, this.cache);
        }
        return null;
    }

    public CatalogResult lookupDocument() {
        logger.finer("lookupDocument()");
        for (int index = 0; index < this.catalogList.size(); ++index) {
            this.loadCatalog(index);
            Document doc = this.documentList.get(index);
            if (doc == null) continue;
            logger.finer("  Looking in " + doc.getBaseURI());
            CatalogResult resolved = this.lookupDocument(doc.getDocumentElement());
            if (resolved == null) continue;
            logger.finer("  Found: " + resolved);
            return resolved;
        }
        logger.finer("  Not found");
        return null;
    }

    protected CatalogResult lookupDocument(Element group) {
        Iterator<Element> i$ = this.entries(group, "document", null, null, null, null).iterator();
        if (i$.hasNext()) {
            Element child = i$.next();
            String localURI = DOMUtils.makeAbsolute(child, child.getAttribute("uri"));
            return new CatalogResult(localURI, localURI, child, this.cache);
        }
        return null;
    }

    public CatalogResult lookupEntity(String entityName, String systemId, String publicId) {
        logger.finer("lookupEntity(" + entityName + "," + publicId + "," + systemId + ")");
        systemId = URIUtils.normalizeURI(systemId);
        if (publicId != null && publicId.startsWith("urn:publicid:")) {
            publicId = PublicId.decodeURN(publicId);
        }
        if (systemId != null && systemId.startsWith("urn:publicid:")) {
            systemId = PublicId.decodeURN(systemId);
            if (publicId != null && !publicId.equals(systemId)) {
                logger.warning("urn:publicid: system identifier differs from public identifier; using public identifier");
                systemId = null;
            } else {
                publicId = systemId;
                systemId = null;
            }
        }
        for (int index = 0; index < this.catalogList.size(); ++index) {
            this.loadCatalog(index);
            Document doc = this.documentList.get(index);
            if (doc == null) continue;
            logger.finer("  Looking in " + doc.getBaseURI());
            CatalogResult resolved = this.lookupEntity(doc.getDocumentElement(), entityName, systemId, publicId);
            if (resolved == null) continue;
            logger.finer("  Found: " + resolved);
            return resolved;
        }
        logger.finer("  Not found");
        return null;
    }

    protected CatalogResult lookupEntity(Element group, String entityName, String systemId, String publicId) {
        CatalogResult resolved = null;
        if (systemId != null && (resolved = this.lookupLocalSystem(group, systemId)) != null) {
            return resolved;
        }
        if (publicId != null && (resolved = this.lookupLocalPublic(group, systemId, publicId)) != null) {
            return resolved;
        }
        for (Element child : this.entries(group, "entity", "name", entityName, null, null)) {
            boolean preferpublic = this.conf.queryPreferPublic();
            Node node = child;
            while (node != null && node.getNodeType() == 1) {
                Element p = node;
                if (p.hasAttribute("prefer")) {
                    preferpublic = "public".equals(p.getAttribute("prefer"));
                    node = null;
                    continue;
                }
                node = node.getParentNode();
            }
            if (!preferpublic && systemId != null) continue;
            String localURI = DOMUtils.makeAbsolute(child, child.getAttribute("uri"));
            String origURI = systemId;
            if (origURI == null) {
                origURI = localURI;
            }
            return new CatalogResult(origURI, localURI, child, this.cache);
        }
        return null;
    }

    public CatalogResult lookupNotation(String notName, String systemId, String publicId) {
        logger.finer("lookupNotation(" + notName + "," + publicId + "," + systemId + ")");
        systemId = URIUtils.normalizeURI(systemId);
        if (publicId != null && publicId.startsWith("urn:publicid:")) {
            publicId = PublicId.decodeURN(publicId);
        }
        if (systemId != null && systemId.startsWith("urn:publicid:")) {
            systemId = PublicId.decodeURN(systemId);
            if (publicId != null && !publicId.equals(systemId)) {
                logger.warning("urn:publicid: system identifier differs from public identifier; using public identifier");
                systemId = null;
            } else {
                publicId = systemId;
                systemId = null;
            }
        }
        for (int index = 0; index < this.catalogList.size(); ++index) {
            this.loadCatalog(index);
            Document doc = this.documentList.get(index);
            if (doc == null) continue;
            logger.finer("  Looking in " + doc.getBaseURI());
            CatalogResult resolved = this.lookupNotation(doc.getDocumentElement(), notName, systemId, publicId);
            if (resolved == null) continue;
            logger.finer("  Found: " + resolved);
            return resolved;
        }
        logger.finer("  Not found");
        return null;
    }

    protected CatalogResult lookupNotation(Element group, String notName, String systemId, String publicId) {
        CatalogResult resolved = null;
        if (systemId != null && (resolved = this.lookupLocalSystem(group, systemId)) != null) {
            return resolved;
        }
        if (publicId != null && (resolved = this.lookupLocalPublic(group, systemId, publicId)) != null) {
            return resolved;
        }
        for (Element child : this.entries(group, "notation", "name", notName, null, null)) {
            boolean preferpublic = this.conf.queryPreferPublic();
            Node node = child;
            while (node != null && node.getNodeType() == 1) {
                Element p = node;
                if (p.hasAttribute("prefer")) {
                    preferpublic = "public".equals(p.getAttribute("prefer"));
                    node = null;
                    continue;
                }
                node = node.getParentNode();
            }
            if (!preferpublic && systemId != null) continue;
            String localURI = DOMUtils.makeAbsolute(child, child.getAttribute("uri"));
            String origURI = systemId;
            if (origURI == null) {
                origURI = localURI;
            }
            return new CatalogResult(origURI, localURI, child, this.cache);
        }
        return null;
    }

    public synchronized void addSource(CatalogSource aCatalogSource) {
        this.catalogList.add(aCatalogSource);
    }

    private static Vector<CatalogSource> createSources(Configuration aConf, String aCatalogFiles) {
        Vector<CatalogSource> res = new Vector<CatalogSource>();
        if (aCatalogFiles == null) {
            for (String s : aConf.queryCatalogFiles()) {
                res.add(new CatalogSource.UriCatalogSource(s));
            }
        } else {
            for (String s : aCatalogFiles.split(";")) {
                if ("".equals(s)) continue;
                res.add(new CatalogSource.UriCatalogSource(s));
            }
        }
        return res;
    }

    private static Vector<CatalogSource> toCatalogSources(Vector<String> aCatalogFiles) {
        Vector<CatalogSource> res = new Vector<CatalogSource>();
        for (String s : aCatalogFiles) {
            res.add(new CatalogSource.UriCatalogSource(s));
        }
        return res;
    }
}

