/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import nu.validator.htmlparser.common.TokenHandler;
import nu.validator.htmlparser.impl.ElementName;
import nu.validator.htmlparser.impl.ErrorReportingTokenizer;
import nu.validator.htmlparser.impl.HtmlAttributes;
import nu.validator.htmlparser.impl.Tokenizer;
import nu.validator.htmlparser.io.Driver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TokenPrinter
implements TokenHandler,
ErrorHandler {
    private final Writer writer;

    @Override
    public void characters(char[] buf, int start, int length) throws SAXException {
        try {
            boolean lineStarted = true;
            this.writer.write(45);
            int i = start;
            while (i < start + length) {
                char c;
                if (!lineStarted) {
                    this.writer.write("\n-");
                    lineStarted = true;
                }
                if ((c = buf[i]) == '\n') {
                    this.writer.write("\\n");
                    lineStarted = false;
                } else {
                    this.writer.write(c);
                }
                ++i;
            }
            this.writer.write(10);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void comment(char[] buf, int start, int length) throws SAXException {
        try {
            this.writer.write(33);
            this.writer.write(buf, start, length);
            this.writer.write(10);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void doctype(String name, String publicIdentifier, String systemIdentifier, boolean forceQuirks) throws SAXException {
        try {
            this.writer.write(68);
            this.writer.write(name);
            this.writer.write(32);
            this.writer.write("" + forceQuirks);
            this.writer.write(10);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void endTag(ElementName eltName) throws SAXException {
        try {
            this.writer.write(41);
            this.writer.write(eltName.name);
            this.writer.write(10);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void eof() throws SAXException {
        try {
            this.writer.write("E\n");
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void startTokenization(Tokenizer self) throws SAXException {
    }

    @Override
    public void startTag(ElementName eltName, HtmlAttributes attributes, boolean selfClosing) throws SAXException {
        try {
            this.writer.write(40);
            this.writer.write(eltName.name);
            this.writer.write(10);
            int i = 0;
            while (i < attributes.getLength()) {
                this.writer.write(65);
                this.writer.write(attributes.getQName(i));
                this.writer.write(32);
                this.writer.write(attributes.getValue(i));
                this.writer.write(10);
                ++i;
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public boolean wantsComments() throws SAXException {
        return true;
    }

    public static void main(String[] args) throws SAXException, IOException {
        TokenPrinter printer = new TokenPrinter(new OutputStreamWriter((OutputStream)System.out, "UTF-8"));
        Driver tokenizer = new Driver(new ErrorReportingTokenizer(printer));
        tokenizer.setErrorHandler(printer);
        File file = new File(args[0]);
        InputSource is = new InputSource(new FileInputStream(file));
        is.setSystemId(file.toURI().toASCIIString());
        tokenizer.tokenize(is);
    }

    public TokenPrinter(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        try {
            this.writer.write("R ");
            this.writer.write(exception.getMessage());
            this.writer.write("\n");
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        try {
            this.writer.write("F ");
            this.writer.write(exception.getMessage());
            this.writer.write("\n");
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        try {
            this.writer.write("W ");
            this.writer.write(exception.getMessage());
            this.writer.write("\n");
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void endTokenization() throws SAXException {
        try {
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void zeroOriginatingReplacementCharacter() throws SAXException {
        try {
            this.writer.write("0\n");
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public boolean cdataSectionAllowed() throws SAXException {
        return false;
    }
}

