/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.test;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SystemErrErrorHandler
implements ErrorHandler,
ErrorListener {
    private Writer out;
    private boolean inError = false;

    public SystemErrErrorHandler() {
        try {
            this.out = new OutputStreamWriter((OutputStream)System.err, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        try {
            this.out.write("Warning:\n");
            this.out.write(e.getMessage());
            this.out.write("\nFile: ");
            String systemId = e.getSystemId();
            this.out.write(systemId == null ? "Unknown" : systemId);
            this.out.write("\nLine: ");
            this.out.write(Integer.toString(e.getLineNumber()));
            this.out.write(" Col: ");
            this.out.write(Integer.toString(e.getColumnNumber()));
            this.out.write("\n\n");
            this.out.flush();
        }
        catch (IOException e1) {
            throw new SAXException(e1);
        }
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.inError = true;
        try {
            this.out.write("Error:\n");
            this.out.write(e.getMessage());
            this.out.write("\nFile: ");
            String systemId = e.getSystemId();
            this.out.write(systemId == null ? "Unknown" : systemId);
            this.out.write("\nLine: ");
            this.out.write(Integer.toString(e.getLineNumber()));
            this.out.write(" Col: ");
            this.out.write(Integer.toString(e.getColumnNumber()));
            this.out.write("\n\n");
            this.out.flush();
        }
        catch (IOException e1) {
            throw new SAXException(e1);
        }
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.inError = true;
        try {
            this.out.write("Fatal Error:\n");
            this.out.write(e.getMessage());
            this.out.write("\nFile: ");
            String systemId = e.getSystemId();
            this.out.write(systemId == null ? "Unknown" : systemId);
            this.out.write("\nLine: ");
            this.out.write(Integer.toString(e.getLineNumber()));
            this.out.write(" Col: ");
            this.out.write(Integer.toString(e.getColumnNumber()));
            this.out.write("\n\n");
            this.out.flush();
        }
        catch (IOException e1) {
            throw new SAXException(e1);
        }
    }

    public boolean isInError() {
        return this.inError;
    }

    public void reset() {
        this.inError = false;
    }

    @Override
    public void error(TransformerException e) throws TransformerException {
        this.inError = true;
        try {
            this.out.write("Error:\n");
            this.out.write(e.getMessage());
            SourceLocator sourceLocator = e.getLocator();
            if (sourceLocator != null) {
                this.out.write("\nFile: ");
                String systemId = sourceLocator.getSystemId();
                this.out.write(systemId == null ? "Unknown" : systemId);
                this.out.write("\nLine: ");
                this.out.write(Integer.toString(sourceLocator.getLineNumber()));
                this.out.write(" Col: ");
                this.out.write(Integer.toString(sourceLocator.getColumnNumber()));
            }
            this.out.write("\n\n");
            this.out.flush();
        }
        catch (IOException e1) {
            throw new TransformerException(e1);
        }
    }

    @Override
    public void fatalError(TransformerException e) throws TransformerException {
        this.inError = true;
        try {
            this.out.write("Fatal Error:\n");
            this.out.write(e.getMessage());
            SourceLocator sourceLocator = e.getLocator();
            if (sourceLocator != null) {
                this.out.write("\nFile: ");
                String systemId = sourceLocator.getSystemId();
                this.out.write(systemId == null ? "Unknown" : systemId);
                this.out.write("\nLine: ");
                this.out.write(Integer.toString(sourceLocator.getLineNumber()));
                this.out.write(" Col: ");
                this.out.write(Integer.toString(sourceLocator.getColumnNumber()));
            }
            this.out.write("\n\n");
            this.out.flush();
        }
        catch (IOException e1) {
            throw new TransformerException(e1);
        }
    }

    @Override
    public void warning(TransformerException e) throws TransformerException {
        try {
            this.out.write("Warning:\n");
            this.out.write(e.getMessage());
            SourceLocator sourceLocator = e.getLocator();
            if (sourceLocator != null) {
                this.out.write("\nFile: ");
                String systemId = sourceLocator.getSystemId();
                this.out.write(systemId == null ? "Unknown" : systemId);
                this.out.write("\nLine: ");
                this.out.write(Integer.toString(sourceLocator.getLineNumber()));
                this.out.write(" Col: ");
                this.out.write(Integer.toString(sourceLocator.getColumnNumber()));
            }
            this.out.write("\n\n");
            this.out.flush();
        }
        catch (IOException e1) {
            throw new TransformerException(e1);
        }
    }
}

