/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.util.S9apiUtils;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;
import org.json.JSONException;
import org.json.JSONStringer;

public class XMLtoJSON {
    private static final int ROOT = 0;
    private static final int OBJECT = 1;
    private static final int ARRAY = 2;
    private static QName _type = new QName("", "type");
    private static QName _name = new QName("", "name");
    private static final QName c_body = new QName("c", "http://www.w3.org/ns/xproc-step", "body");

    public static String convert(XdmNode json) {
        JSONStringer js = new JSONStringer();
        if (c_body.equals((json = S9apiUtils.getDocumentElement(json)).getNodeName())) {
            XdmNode jchild = null;
            XdmSequenceIterator iter = json.axisIterator(Axis.CHILD);
            while (iter.hasNext()) {
                XdmNode child;
                XdmItem item = iter.next();
                if (!(item instanceof XdmNode) || (child = (XdmNode)item).getNodeKind() != XdmNodeKind.ELEMENT) continue;
                if (jchild != null) {
                    throw new XProcException("Found c:body containing more than one JSON element?");
                }
                jchild = child;
            }
            json = jchild;
        }
        try {
            XMLtoJSON.build(json, js, 0);
        }
        catch (JSONException jse) {
            throw new XProcException(jse);
        }
        return js.toString();
    }

    private static void build(XdmNode json, JSONStringer js, int context) throws JSONException {
        String type = null;
        type = "http://www.ibm.com/xmlns/prod/2009/jsonx".equals(json.getNodeName().getNamespaceURI()) || "http://www.xmlsh.org/jxml".equals(json.getNodeName().getNamespaceURI()) ? json.getNodeName().getLocalName() : json.getAttributeValue(_type);
        String name = null;
        if ("http://marklogic.com/json".equals(json.getNodeName().getNamespaceURI())) {
            name = json.getNodeName().getLocalName();
            if (name.contains("_")) {
                if ("_".equals(name)) {
                    name = "";
                } else {
                    String decoded = "";
                    int upos = name.indexOf("_");
                    while (upos >= 0) {
                        decoded = String.valueOf(decoded) + name.substring(0, upos);
                        String hex = name.substring(upos + 1, upos + 5);
                        int ch = Integer.parseInt(hex, 16);
                        decoded = String.valueOf(decoded) + Character.toString((char)ch);
                        name = name.substring(upos + 5);
                        upos = name.indexOf("_");
                    }
                    name = String.valueOf(decoded) + name;
                }
            }
        } else {
            name = json.getAttributeValue(_name);
        }
        if (context == 1 && name != null) {
            js.key(name);
        }
        if ("object".equals(type)) {
            js.object();
            XMLtoJSON.processChildren(json, js, 1);
            js.endObject();
        } else if ("array".equals(type)) {
            js.array();
            XMLtoJSON.processChildren(json, js, 2);
            js.endArray();
        } else if ("member".equals(type)) {
            XMLtoJSON.processChildren(json, js, 1);
        } else if ("null".equals(type)) {
            js.value(null);
        } else if ("number".equals(type)) {
            String value = json.getStringValue();
            if (value.contains(".")) {
                Double d = Double.parseDouble(value);
                js.value(d);
            } else {
                long i = Long.parseLong(value);
                js.value(i);
            }
        } else if ("boolean".equals(type)) {
            js.value("true".equals(json.getStringValue()));
        } else {
            js.value(json.getStringValue());
        }
    }

    private static void processChildren(XdmNode json, JSONStringer js, int context) throws JSONException {
        XdmSequenceIterator iter = json.axisIterator(Axis.CHILD);
        while (iter.hasNext()) {
            XdmNode child;
            XdmItem item = iter.next();
            if (!(item instanceof XdmNode) || (child = (XdmNode)item).getNodeKind() != XdmNodeKind.ELEMENT) continue;
            XMLtoJSON.build(child, js, context);
        }
    }
}

