/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.ItemTypeFactory;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmNode;

public class TypeUtils {
    private static final QName _XSLTMatchPattern = new QName("XSLTMatchPattern");
    private static final QName _RegularExpression = new QName("RegularExpression");
    private static final QName _ListOfQNames = new QName("ListOfQNames");
    private static final QName _XPathExpression = new QName("XPathExpression");
    private static final QName _NormalizationForm = new QName("NormalizationForm");
    private static final QName err_XD0045 = new QName("http://www.w3.org/ns/xproc-error", "XD0045");
    private static int anonTypeCount = 0;

    public static QName generateUniqueType(String baseName) {
        String localName = String.valueOf(baseName) + "_" + ++anonTypeCount;
        return new QName("http://xmlcalabash.com/ns/extensions", localName);
    }

    public static QName generateUniqueType() {
        return TypeUtils.generateUniqueType("anonymousType");
    }

    public static void checkLiteral(String value, String literals) {
        String[] values;
        String[] stringArray = values = literals.split("\\|");
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String v = stringArray[n2];
            if (v.equals(value)) {
                return;
            }
            ++n2;
        }
        throw XProcException.dynamicError(45, "Invalid value: \"" + value + "\" must be one of \"" + literals + "\".");
    }

    public static void checkType(XProcRuntime runtime, String value, QName type, XdmNode node) {
        TypeUtils.checkType(runtime, value, type, node, err_XD0045);
    }

    public static void checkType(XProcRuntime runtime, String value, QName type, XdmNode node, QName error) {
        if (XProcConstants.xs_string.equals(type) || XProcConstants.xs_untypedAtomic.equals(type)) {
            return;
        }
        if (_XSLTMatchPattern.equals(type) || _RegularExpression.equals(type) || _ListOfQNames.equals(type) || _XPathExpression.equals(type) || _NormalizationForm.equals(type)) {
            return;
        }
        if (XProcConstants.xs_QName.equals(type)) {
            try {
                QName name = new QName(value, node);
            }
            catch (Exception e) {
                throw new XProcException(error, (Throwable)e);
            }
            return;
        }
        ItemTypeFactory typeFactory = new ItemTypeFactory(runtime.getProcessor());
        ItemType itype = null;
        try {
            itype = typeFactory.getAtomicType(type);
        }
        catch (SaxonApiException sae) {
            throw new XProcException("Unexpected type: " + type);
        }
        try {
            XdmAtomicValue avalue = new XdmAtomicValue(value, itype);
        }
        catch (SaxonApiException sae) {
            throw new XProcException(error, (Throwable)sae);
        }
    }
}

