/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.util.Base64;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.XMLtoJSON;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;

public class NodeToBytes {
    private static final QName _encoding = new QName("encoding");
    private static final QName _content_type = new QName("content-type");
    private static final QName c_encoding = new QName("c", "http://www.w3.org/ns/xproc-step", "encoding");
    private static final QName c_body = new QName("c", "http://www.w3.org/ns/xproc-step", "body");
    private static final QName c_json = new QName("c", "http://www.w3.org/ns/xproc-step", "json");
    private static final QName cx_decode = new QName("cx", "http://xmlcalabash.com/ns/extensions", "decode");

    private NodeToBytes() {
    }

    public static byte[] convert(XProcRuntime runtime, XdmNode doc, boolean decode) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        XdmNode root = S9apiUtils.getDocumentElement(doc);
        if (decode && ("http://www.w3.org/ns/xproc-step".equals(root.getNodeName().getNamespaceURI()) && "base64".equals(root.getAttributeValue(_encoding)) || "".equals(root.getNodeName().getNamespaceURI()) && "base64".equals(root.getAttributeValue(c_encoding)))) {
            NodeToBytes.storeBinary(doc, stream);
        } else if (runtime.transparentJSON() && (c_body.equals(root.getNodeName()) && ("application/json".equals(root.getAttributeValue(_content_type)) || "text/json".equals(root.getAttributeValue(_content_type))) || c_json.equals(root.getNodeName()) || "http://www.ibm.com/xmlns/prod/2009/jsonx".equals(root.getNodeName().getNamespaceURI()) || "http://www.xmlsh.org/jxml".equals(root.getNodeName().getNamespaceURI()) || "http://marklogic.com/json".equals(root.getNodeName().getNamespaceURI()))) {
            NodeToBytes.storeJSON(doc, stream);
        } else {
            NodeToBytes.storeXML(runtime, doc, stream);
        }
        return stream.toByteArray();
    }

    private static void storeXML(XProcRuntime runtime, XdmNode doc, OutputStream stream) {
        Serializer serializer = new Serializer();
        serializer.setOutputProperty(Serializer.Property.ENCODING, "utf-8");
        serializer.setOutputProperty(Serializer.Property.INDENT, "no");
        serializer.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
        serializer.setOutputProperty(Serializer.Property.METHOD, "xml");
        try {
            serializer.setOutputStream(stream);
            S9apiUtils.serialize(runtime, doc, serializer);
            stream.close();
        }
        catch (IOException ioe) {
            throw new XProcException("Failed to serialize as XML: " + doc, (Throwable)ioe);
        }
        catch (SaxonApiException sae) {
            throw new XProcException("Failed to serialize as XML: " + doc, (Throwable)sae);
        }
    }

    private static void storeBinary(XdmNode doc, OutputStream stream) {
        try {
            byte[] decoded = Base64.decode(doc.getStringValue());
            stream.write(decoded);
            stream.close();
        }
        catch (IOException ioe) {
            throw new XProcException(ioe);
        }
    }

    private static void storeJSON(XdmNode doc, OutputStream stream) {
        try {
            PrintWriter writer = new PrintWriter(stream);
            String json = XMLtoJSON.convert(doc);
            writer.print(json);
            writer.close();
            stream.close();
        }
        catch (IOException ioe) {
            throw XProcException.stepError(50, ioe);
        }
    }
}

