/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.config.XMLCalabashConfigurer;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadableData;
import com.xmlcalabash.io.ReadableDocument;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.library.Load;
import com.xmlcalabash.model.DataBinding;
import com.xmlcalabash.model.DocumentBinding;
import com.xmlcalabash.model.RuntimeValue;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;

public class DefaultXMLCalabashConfigurer
implements XMLCalabashConfigurer {
    private static final QName _href = new QName("href");
    private static final QName _dtd_validate = new QName("dtd-validate");
    private static final QName cx_filemask = new QName("cx", "http://xmlcalabash.com/ns/extensions", "filemask");
    protected XProcRuntime runtime = null;

    public DefaultXMLCalabashConfigurer(XProcRuntime runtime) {
        this.runtime = runtime;
    }

    @Override
    public void configRuntime(XProcRuntime runtime) {
    }

    @Override
    public XdmNode loadDocument(Load load) {
        boolean validate = load.getOption(_dtd_validate, false);
        RuntimeValue href = load.getOption(_href);
        String base = href.getBaseURI().toASCIIString();
        if (this.runtime.getSafeMode() && base.startsWith("file:")) {
            throw XProcException.dynamicError(21);
        }
        return this.runtime.parse(href.getString(), base, validate);
    }

    @Override
    public ReadablePipe makeReadableData(XProcRuntime runtime, DataBinding binding) {
        return new ReadableData(runtime, binding.getWrapper(), binding.getHref(), binding.getContentType());
    }

    @Override
    public ReadablePipe makeReadableDocument(XProcRuntime runtime, DocumentBinding binding) {
        String mask = binding.getExtensionAttribute(cx_filemask);
        String base = binding.getNode().getBaseURI().toASCIIString();
        return new ReadableDocument(runtime, binding.getNode(), binding.getHref(), base, mask);
    }
}

