/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.CollectionResolver;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TreeWriter;
import com.xmlcalabash.util.XProcURIResolver;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.transform.Result;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.lib.CollectionURIResolver;
import net.sf.saxon.lib.OutputURIResolver;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.MessageListener;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.ValidationMode;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import org.xml.sax.InputSource;

public class XSLT
extends DefaultStep {
    private static final QName _initial_mode = new QName("", "initial-mode");
    private static final QName _template_name = new QName("", "template-name");
    private static final QName _output_base_uri = new QName("", "output-base-uri");
    private static final QName _version = new QName("", "version");
    private ReadablePipe sourcePipe = null;
    private ReadablePipe stylesheetPipe = null;
    private WritablePipe resultPipe = null;
    private WritablePipe secondaryPipe = null;
    private Hashtable<QName, RuntimeValue> params = new Hashtable();
    private Hashtable<String, XdmDestination> secondaryResults = new Hashtable();

    public XSLT(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        if ("source".equals(port)) {
            this.sourcePipe = pipe;
        } else {
            this.stylesheetPipe = pipe;
        }
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        if ("result".equals(port)) {
            this.resultPipe = pipe;
        } else {
            this.secondaryPipe = pipe;
        }
    }

    @Override
    public void setParameter(QName name, RuntimeValue value) {
        this.params.put(name, value);
    }

    @Override
    public void reset() {
        this.sourcePipe.resetReader();
        this.stylesheetPipe.resetReader();
        this.resultPipe.resetWriter();
        this.secondaryPipe.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        XdmNode stylesheet = this.stylesheetPipe.read();
        if (stylesheet == null) {
            throw XProcException.dynamicError(6, this.step.getNode(), "No stylesheet provided.");
        }
        Vector<XdmNode> defaultCollection = new Vector<XdmNode>();
        while (this.sourcePipe.moreDocuments()) {
            defaultCollection.add(this.sourcePipe.read());
        }
        XdmNode document = null;
        if (defaultCollection.size() > 0) {
            document = (XdmNode)defaultCollection.firstElement();
        }
        String version = null;
        if (this.getOption(_version) == null) {
            XdmNode ssroot = S9apiUtils.getDocumentElement(stylesheet);
            version = ssroot.getAttributeValue(new QName("", "version"));
            if (version == null) {
                version = ssroot.getAttributeValue(new QName("http://www.w3.org/1999/XSL/Transform", "version"));
            }
            if (version == null) {
                version = "2.0";
            }
        } else {
            version = this.getOption(_version).getString();
        }
        if ("3.0".equals(version) && Configuration.softwareEdition.toLowerCase().equals("he")) {
            throw XProcException.stepError(38, "XSLT version '" + version + "' is not supported (Saxon PE or EE processor required).");
        }
        if ("1.0".equals(version) && defaultCollection.size() > 1) {
            throw XProcException.stepError(39);
        }
        if ("1.0".equals(version) && this.runtime.getUseXslt10Processor()) {
            this.run10(stylesheet, document);
            return;
        }
        QName initialMode = null;
        QName templateName = null;
        String outputBaseURI = null;
        RuntimeValue opt = this.getOption(_initial_mode);
        if (opt != null) {
            initialMode = opt.getQName();
        }
        if ((opt = this.getOption(_template_name)) != null) {
            templateName = opt.getQName();
        }
        if ((opt = this.getOption(_output_base_uri)) != null) {
            outputBaseURI = opt.getString();
        }
        Processor processor = this.runtime.getProcessor();
        Configuration config = processor.getUnderlyingConfiguration();
        this.runtime.getConfigurer().getSaxonConfigurer().configXSLT(config);
        OutputURIResolver uriResolver = config.getOutputURIResolver();
        CollectionURIResolver collectionResolver = config.getCollectionURIResolver();
        XProcURIResolver unparsedTextURIResolver = this.runtime.getResolver();
        config.setOutputURIResolver(new OutputResolver());
        config.setCollectionURIResolver(new CollectionResolver(this.runtime, defaultCollection, collectionResolver));
        XdmDestination result = null;
        try {
            XsltCompiler compiler = this.runtime.getProcessor().newXsltCompiler();
            compiler.setSchemaAware(processor.isSchemaAware());
            XsltExecutable exec = compiler.compile(stylesheet.asSource());
            XsltTransformer transformer = exec.load();
            for (QName name : this.params.keySet()) {
                RuntimeValue v = this.params.get(name);
                if (this.runtime.getAllowGeneralExpressions()) {
                    transformer.setParameter(name, v.getValue());
                    continue;
                }
                transformer.setParameter(name, new XdmAtomicValue(v.getString()));
            }
            if (document != null) {
                transformer.setInitialContextNode(document);
            }
            transformer.setMessageListener(new CatchMessages());
            result = new XdmDestination();
            transformer.setDestination(result);
            if (initialMode != null) {
                transformer.setInitialMode(initialMode);
            }
            if (templateName != null) {
                transformer.setInitialTemplate(templateName);
            }
            if (outputBaseURI != null) {
                transformer.setBaseOutputURI(outputBaseURI);
                try {
                    result.setBaseURI(new URI(outputBaseURI));
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            transformer.setSchemaValidationMode(ValidationMode.DEFAULT);
            transformer.getUnderlyingController().setUnparsedTextURIResolver(unparsedTextURIResolver);
            transformer.transform();
        }
        finally {
            config.setOutputURIResolver(uriResolver);
            config.setCollectionURIResolver(collectionResolver);
        }
        XdmNode xformed = result.getXdmNode();
        if (xformed != null) {
            if (document != null && (xformed.getBaseURI() == null || "".equals(xformed.getBaseURI().toASCIIString()))) {
                String sysId = document.getBaseURI().toASCIIString();
                xformed.getUnderlyingNode().setSystemId(sysId);
            }
            this.resultPipe.write(xformed);
        }
    }

    public void run10(XdmNode stylesheet, XdmNode document) {
        try {
            InputSource is = S9apiUtils.xdmToInputSource(this.runtime, stylesheet);
            TransformerFactory tfactory = TransformerFactory.newInstance();
            Transformer transformer = tfactory.newTransformer(new SAXSource(is));
            transformer.setURIResolver(this.runtime.getResolver());
            for (QName name : this.params.keySet()) {
                RuntimeValue v = this.params.get(name);
                transformer.setParameter(name.getClarkName(), v.getString());
            }
            DOMResult result = new DOMResult();
            is = S9apiUtils.xdmToInputSource(this.runtime, document);
            transformer.transform(new SAXSource(is), result);
            DocumentBuilder xdmBuilder = this.runtime.getConfiguration().getProcessor().newDocumentBuilder();
            XdmNode xformed = xdmBuilder.build(new DOMSource(result.getNode()));
            if (xformed != null) {
                if (document != null && (xformed.getBaseURI() == null || "".equals(xformed.getBaseURI().toASCIIString()))) {
                    String sysId = document.getBaseURI().toASCIIString();
                    xformed.getUnderlyingNode().setSystemId(sysId);
                }
                this.resultPipe.write(xformed);
            }
        }
        catch (SaxonApiException sae) {
            throw new XProcException(sae);
        }
        catch (TransformerConfigurationException tce) {
            throw new XProcException(tce);
        }
        catch (TransformerException te) {
            throw new XProcException(te);
        }
    }

    class CatchMessages
    implements MessageListener {
        @Override
        public void message(XdmNode content, boolean terminate, SourceLocator locator) {
            TreeWriter treeWriter = new TreeWriter(XSLT.this.runtime);
            treeWriter.startDocument(content.getBaseURI());
            treeWriter.addStartElement(XProcConstants.c_error);
            treeWriter.startContent();
            treeWriter.addSubtree(content);
            treeWriter.addEndElement();
            treeWriter.endDocument();
            XSLT.this.step.reportError(treeWriter.getResult());
            XSLT.this.step.info(XSLT.this.step.getNode(), content.toString());
        }
    }

    class OutputResolver
    implements OutputURIResolver {
        @Override
        public OutputURIResolver newInstance() {
            return new OutputResolver();
        }

        @Override
        public Result resolve(String href, String base) throws TransformerException {
            URI baseURI = null;
            try {
                baseURI = new URI(base);
                baseURI = baseURI.resolve(href);
            }
            catch (URISyntaxException use) {
                throw new XProcException(use);
            }
            XSLT.this.finest(XSLT.this.step.getNode(), "XSLT secondary result document: " + baseURI);
            try {
                XdmDestination xdmResult = new XdmDestination();
                XSLT.this.secondaryResults.put(baseURI.toASCIIString(), xdmResult);
                Receiver receiver = xdmResult.getReceiver(XSLT.this.runtime.getProcessor().getUnderlyingConfiguration());
                receiver.setSystemId(baseURI.toASCIIString());
                return receiver;
            }
            catch (SaxonApiException sae) {
                throw new XProcException(sae);
            }
        }

        @Override
        public void close(Result result) throws TransformerException {
            String href = result.getSystemId();
            XdmDestination xdmResult = (XdmDestination)XSLT.this.secondaryResults.get(href);
            XdmNode doc = xdmResult.getXdmNode();
            XSLT.this.secondaryPipe.write(doc);
        }
    }
}

