/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TreeWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Vector;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SchemaManager;
import net.sf.saxon.s9api.SchemaValidator;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmNode;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ValidateWithXSD
extends DefaultStep {
    private static final QName _assert_valid = new QName("", "assert-valid");
    private static final QName _mode = new QName("", "mode");
    private static final QName _use_location_hints = new QName("", "use-location-hints");
    private static final QName _try_namespaces = new QName("", "try-namespaces");
    private static final QName _line = new QName("line");
    private static final QName _column = new QName("column");
    private static final Class[] paramTypes = new Class[0];
    private ReadablePipe source = null;
    private ReadablePipe schemas = null;
    private WritablePipe result = null;
    private URI docBaseURI = null;
    private Throwable validationException = null;

    public ValidateWithXSD(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        if ("source".equals(port)) {
            this.source = pipe;
        } else if ("schema".equals(port)) {
            this.schemas = pipe;
        }
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        Processor proc = this.runtime.getProcessor();
        SchemaManager manager = proc.getSchemaManager();
        if (manager == null) {
            this.validateWithXerces();
        } else {
            this.validateWithSaxonSA(manager);
        }
    }

    public void validateWithSaxonSA(SchemaManager manager) throws SaxonApiException {
        XdmDestination destination;
        block13: {
            this.fine(this.step.getNode(), "Validating with Saxon");
            Configuration config = this.runtime.getProcessor().getUnderlyingConfiguration();
            this.runtime.getConfigurer().getSaxonConfigurer().configXSD(config);
            try {
                Method clearSchemaCache = config.getClass().getMethod("clearSchemaCache", paramTypes);
                clearSchemaCache.invoke((Object)config, new Object[0]);
                this.finest(this.step.getNode(), "Cleared schema cache.");
            }
            catch (NoSuchMethodException nsme) {
                this.finest(this.step.getNode(), "Cannot reset schema cache.");
            }
            catch (IllegalAccessException nsme) {
                this.finest(this.step.getNode(), "Cannot reset schema cache.");
            }
            catch (InvocationTargetException nsme) {
                this.finest(this.step.getNode(), "Cannot reset schema cache.");
            }
            XdmNode doc = this.source.read();
            this.docBaseURI = doc.getBaseURI();
            String namespace = S9apiUtils.getDocumentElement(doc).getNodeName().getNamespaceURI();
            boolean tryNamespaces = this.getOption(_try_namespaces, false) && !"".equals(namespace);
            Vector<XdmNode> schemaDocuments = new Vector<XdmNode>();
            while (this.schemas.moreDocuments()) {
                XdmNode schemaNode = this.schemas.read();
                String targetNS = schemaNode.getBaseURI().toASCIIString();
                this.finer(this.step.getNode(), "Caching input schema: " + (String)targetNS);
                if (targetNS.equals(namespace)) {
                    tryNamespaces = false;
                }
                schemaDocuments.add(schemaNode);
                this.runtime.getResolver().cache(schemaNode, schemaNode.getBaseURI());
            }
            if (tryNamespaces) {
                try {
                    XdmNode nsSchemaDoc = this.runtime.parse(namespace, doc.getBaseURI().toASCIIString(), false);
                    schemaDocuments.add(nsSchemaDoc);
                    this.runtime.getResolver().cache(nsSchemaDoc, nsSchemaDoc.getBaseURI());
                }
                catch (Exception nsSchemaDoc) {
                    // empty catch block
                }
            }
            for (XdmNode schemaNode : schemaDocuments) {
                InputSource schemaSource = S9apiUtils.xdmToInputSource(this.runtime, schemaNode);
                schemaSource.setSystemId(schemaNode.getBaseURI().toASCIIString());
                SAXSource source = new SAXSource(schemaSource);
                manager.load(source);
            }
            destination = new XdmDestination();
            Controller controller = new Controller(config);
            Receiver receiver = destination.getReceiver(controller.getConfiguration());
            PipelineConfiguration pipe = controller.makePipelineConfiguration();
            pipe.setRecoverFromValidationErrors(!this.getOption(_assert_valid, false));
            receiver.setPipelineConfiguration(pipe);
            SchemaValidator validator = manager.newSchemaValidator();
            validator.setDestination(destination);
            validator.setErrorListener(new XSDErrorHandler());
            String mode = this.getOption(_mode, "strict");
            validator.setLax("lax".equals(mode));
            boolean useHints = this.getOption(_use_location_hints, false);
            validator.setUseXsiSchemaLocation(useHints);
            try {
                this.finer(this.step.getNode(), "Validating: " + doc.getBaseURI().toASCIIString());
                validator.validate(doc.asSource());
                if (this.validationException != null) {
                    throw (SaxonApiException)this.validationException;
                }
            }
            catch (SaxonApiException sae) {
                if (!this.getOption(_assert_valid, false)) break block13;
                throw new XProcException(XProcConstants.stepError(53), (Throwable)sae);
            }
        }
        XdmNode valid = destination.getXdmNode();
        this.result.write(valid);
    }

    private void validateWithXerces() throws SaxonApiException {
        this.fine(this.step.getNode(), "Validating with Xerces");
        Vector<XdmNode> schemaDocuments = new Vector<XdmNode>();
        while (this.schemas.moreDocuments()) {
            XdmNode schemaNode = this.schemas.read();
            schemaDocuments.add(schemaNode);
            this.runtime.getResolver().cache(schemaNode, schemaNode.getBaseURI());
        }
        XdmNode doc = this.source.read();
        this.docBaseURI = doc.getBaseURI();
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            this.runtime.getConfigurer().getJaxpConfigurer().configSchemaFactory(factory);
            XdmNode schemaNode = (XdmNode)schemaDocuments.get(0);
            InputSource is = S9apiUtils.xdmToInputSource(this.runtime, schemaNode);
            is.setSystemId(schemaNode.getBaseURI().toASCIIString());
            Schema schema = factory.newSchema(new SAXSource(is));
            Validator validator = schema.newValidator();
            validator.setErrorHandler(new XSDErrorHandler());
            InputSource docSource = S9apiUtils.xdmToInputSource(this.runtime, doc);
            docSource.setSystemId(doc.getBaseURI().toASCIIString());
            try {
                validator.validate(new SAXSource(docSource));
                if (this.validationException != null) {
                    throw (SAXParseException)this.validationException;
                }
            }
            catch (SAXParseException spe) {
                if (this.getOption(_assert_valid, false)) {
                    throw new XProcException(XProcConstants.stepError(53), (Throwable)spe);
                }
            }
        }
        catch (SAXException se) {
            throw new XProcException(se);
        }
        catch (IOException ioe) {
            throw new XProcException(ioe);
        }
        this.result.write(doc);
    }

    class XSDErrorHandler
    implements ErrorHandler,
    ErrorListener {
        XSDErrorHandler() {
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.error(e);
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            TreeWriter treeWriter = new TreeWriter(ValidateWithXSD.this.runtime);
            treeWriter.startDocument(ValidateWithXSD.this.docBaseURI);
            treeWriter.addStartElement(XProcConstants.c_error);
            if (e.getLineNumber() != -1) {
                treeWriter.addAttribute(_line, "" + e.getLineNumber());
            }
            if (e.getColumnNumber() != -1) {
                treeWriter.addAttribute(_column, "" + e.getColumnNumber());
            }
            treeWriter.startContent();
            treeWriter.addText(e.toString());
            treeWriter.addEndElement();
            treeWriter.addText("\n");
            treeWriter.endDocument();
            ValidateWithXSD.this.step.reportError(treeWriter.getResult());
            if (ValidateWithXSD.this.validationException == null) {
                ValidateWithXSD.this.validationException = e;
            }
        }

        @Override
        public void warning(SAXParseException e) {
        }

        @Override
        public void warning(TransformerException e) throws TransformerException {
        }

        @Override
        public void error(TransformerException e) throws TransformerException {
            TreeWriter treeWriter = new TreeWriter(ValidateWithXSD.this.runtime);
            treeWriter.startDocument(ValidateWithXSD.this.docBaseURI);
            treeWriter.addStartElement(XProcConstants.c_error);
            SourceLocator loc = e.getLocator();
            if (loc != null) {
                if (loc.getLineNumber() != -1) {
                    treeWriter.addAttribute(_line, "" + loc.getLineNumber());
                }
                if (loc.getColumnNumber() != -1) {
                    treeWriter.addAttribute(_column, "" + loc.getColumnNumber());
                }
            }
            treeWriter.startContent();
            treeWriter.addText(e.toString());
            treeWriter.addEndElement();
            treeWriter.addText("\n");
            treeWriter.endDocument();
            ValidateWithXSD.this.step.reportError(treeWriter.getResult());
            if (ValidateWithXSD.this.validationException == null) {
                ValidateWithXSD.this.validationException = e;
            }
        }

        @Override
        public void fatalError(TransformerException e) throws TransformerException {
            this.error(e);
        }
    }
}

