/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.ProcessMatch;
import com.xmlcalabash.util.ProcessMatchingNodes;
import com.xmlcalabash.util.S9apiUtils;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;

public class Template
extends DefaultStep
implements ProcessMatchingNodes {
    private ReadablePipe source = null;
    private ReadablePipe template = null;
    private WritablePipe result = null;
    private Hashtable<QName, RuntimeValue> params = new Hashtable();
    private ProcessMatch matcher = null;
    private XdmNode context = null;
    private static final int START = 0;
    private static final int XPATHMODE = 1;
    private static final int SQUOTEMODE = 2;
    private static final int DQUOTEMODE = 3;
    private static final int END = 4;

    public Template(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        if ("source".equals(port)) {
            this.source = pipe;
        } else if ("template".equals(port)) {
            this.template = pipe;
        } else {
            throw new UnsupportedOperationException("WTF?");
        }
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void setParameter(QName name, RuntimeValue value) {
        this.params.put(name, value);
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
        this.template.resetReader();
    }

    @Override
    public void run() throws SaxonApiException {
        if (this.step.getNode().getNodeName().equals(XProcConstants.p_document_template)) {
            this.runtime.finer(this, this.step.getNode(), "The template step should be named p:template, the name p:document-template is deprecated.");
        }
        super.run();
        if (this.source.documentCount() > 1) {
            throw XProcException.stepError(68);
        }
        this.context = this.source.read();
        this.matcher = new ProcessMatch(this.runtime, this);
        this.matcher.match(this.template.read(), new RuntimeValue("node()", this.step.getNode()));
        this.result.write(this.matcher.getResult());
    }

    @Override
    public boolean processStartDocument(XdmNode node) throws SaxonApiException {
        this.matcher.startDocument(node.getBaseURI());
        return true;
    }

    @Override
    public void processEndDocument(XdmNode node) throws SaxonApiException {
        this.matcher.endDocument();
    }

    @Override
    public boolean processStartElement(XdmNode node) throws SaxonApiException {
        this.matcher.addStartElement(node);
        XdmSequenceIterator iter = node.axisIterator(Axis.ATTRIBUTE);
        while (iter.hasNext()) {
            XdmNode attr = (XdmNode)iter.next();
            String value = attr.getStringValue();
            if (value.contains("{") || value.contains("}")) {
                Vector<XdmItem> items = this.parse(attr, value);
                String newvalue = "";
                for (XdmItem item : items) {
                    newvalue = String.valueOf(newvalue) + item.getStringValue();
                }
                this.matcher.addAttribute(attr, newvalue);
                continue;
            }
            this.matcher.addAttribute(attr);
        }
        return true;
    }

    @Override
    public void processEndElement(XdmNode node) throws SaxonApiException {
        this.matcher.addEndElement();
    }

    @Override
    public void processText(XdmNode node) throws SaxonApiException {
        String value = node.getStringValue();
        if (value.contains("{") || value.contains("}")) {
            Vector<XdmItem> items = this.parse(node, value);
            for (XdmItem item : items) {
                if (item.isAtomicValue()) {
                    this.matcher.addText(item.getStringValue());
                    continue;
                }
                XdmNode nitem = (XdmNode)item;
                switch (nitem.getNodeKind()) {
                    case ELEMENT: {
                        this.matcher.addSubtree(nitem);
                        break;
                    }
                    case ATTRIBUTE: {
                        this.matcher.addAttribute(nitem);
                        break;
                    }
                    case PROCESSING_INSTRUCTION: {
                        this.matcher.addSubtree(nitem);
                        break;
                    }
                    case COMMENT: {
                        this.matcher.addComment(nitem.getStringValue());
                        break;
                    }
                    default: {
                        this.matcher.addText(nitem.getStringValue());
                    }
                }
            }
        } else {
            this.matcher.addText(value);
        }
    }

    private Vector<XdmItem> parse(XdmNode node, String value) {
        Vector<XdmItem> items = new Vector<XdmItem>();
        int state = 0;
        String ptext = "";
        String ch = "";
        Hashtable<String, String> nsbindings = new Hashtable<String, String>();
        XdmNode parent = node;
        while (parent != null && parent.getNodeKind() != XdmNodeKind.ELEMENT && parent.getNodeKind() != XdmNodeKind.DOCUMENT) {
            parent = S9apiUtils.getParent(parent);
        }
        if (parent.getNodeKind() == XdmNodeKind.ELEMENT) {
            NodeInfo inode = parent.getUnderlyingNode();
            InscopeNamespaceResolver inscopeNS = new InscopeNamespaceResolver(inode);
            Iterator<String> prefixes = inscopeNS.iteratePrefixes();
            while (prefixes.hasNext()) {
                String nspfx = prefixes.next();
                String nsuri = inscopeNS.getURIForPrefix(nspfx, true);
                nsbindings.put(nspfx, nsuri);
            }
        }
        String peek = "";
        int pos = 0;
        while (pos < value.length()) {
            ch = value.substring(pos, pos + 1);
            switch (state) {
                case 0: {
                    peek = pos + 1 < value.length() ? value.substring(pos + 1, pos + 2) : "";
                    if ("{".equals(ch)) {
                        if ("{".equals(peek)) {
                            ptext = String.valueOf(ptext) + "{";
                            ++pos;
                            break;
                        }
                        if (!"".equals(ptext)) {
                            items.add(new XdmAtomicValue(ptext));
                            ptext = "";
                        }
                        state = 1;
                        break;
                    }
                    if ("}".equals(ch)) {
                        if ("}".equals(peek)) {
                            ptext = String.valueOf(ptext) + "}";
                            ++pos;
                            break;
                        }
                        throw XProcException.stepError(67);
                    }
                    ptext = String.valueOf(ptext) + ch;
                    break;
                }
                case 1: {
                    if ("{".equals(ch)) {
                        throw XProcException.stepError(67);
                    }
                    if ("'".equals(ch)) {
                        ptext = String.valueOf(ptext) + "'";
                        state = 2;
                        break;
                    }
                    if ("\"".equals(ch)) {
                        ptext = String.valueOf(ptext) + "\"";
                        state = 3;
                        break;
                    }
                    if ("}".equals(ch)) {
                        items.addAll(this.evaluateXPath(this.context, nsbindings, ptext, this.params));
                        ptext = "";
                        state = 0;
                        break;
                    }
                    ptext = String.valueOf(ptext) + ch;
                    break;
                }
                case 2: {
                    if ("'".equals(ch)) {
                        ptext = String.valueOf(ptext) + "'";
                        state = 1;
                        break;
                    }
                    ptext = String.valueOf(ptext) + ch;
                    break;
                }
                case 3: {
                    if ("\"".equals(ch)) {
                        ptext = String.valueOf(ptext) + "\"";
                        state = 1;
                        break;
                    }
                    ptext = String.valueOf(ptext) + ch;
                }
            }
            ++pos;
        }
        if (state != 0) {
            throw XProcException.stepError(67);
        }
        if (!"".equals(ptext)) {
            items.add(new XdmAtomicValue(ptext));
        }
        return items;
    }

    @Override
    public void processComment(XdmNode node) throws SaxonApiException {
        String value = node.getStringValue();
        if (value.contains("{") || value.contains("}")) {
            Vector<XdmItem> items = this.parse(node, value);
            String newvalue = "";
            for (XdmItem item : items) {
                newvalue = String.valueOf(newvalue) + item.getStringValue();
            }
            this.matcher.addComment(newvalue);
        } else {
            this.matcher.addComment(value);
        }
    }

    @Override
    public void processPI(XdmNode node) throws SaxonApiException {
        String value = node.getStringValue();
        if (value.contains("{") || value.contains("}")) {
            Vector<XdmItem> items = this.parse(node, value);
            String newvalue = "";
            for (XdmItem item : items) {
                newvalue = String.valueOf(newvalue) + item.getStringValue();
            }
            this.matcher.addPI(node.getNodeName().getLocalName(), newvalue);
        } else {
            this.matcher.addPI(node.getNodeName().getLocalName(), value);
        }
    }

    @Override
    public void processAttribute(XdmNode node) throws SaxonApiException {
        throw new UnsupportedOperationException("This can't happen.");
    }
}

