/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.io;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.DocumentSequence;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.util.JSONtoXML;
import com.xmlcalabash.util.XPointer;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import org.json.JSONTokener;

public class ReadableDocument
implements ReadablePipe {
    protected DocumentSequence documents = null;
    protected String uri = null;
    protected XProcRuntime runtime = null;
    private int pos = 0;
    private String base = null;
    private XdmNode node = null;
    private boolean readDoc = false;
    private Step reader = null;
    private Pattern pattern = null;

    public ReadableDocument(XProcRuntime runtime) {
        this.runtime = runtime;
        this.documents = new DocumentSequence(runtime);
    }

    public ReadableDocument(XProcRuntime runtime, XdmNode node, String uri, String base, String mask) {
        this.runtime = runtime;
        this.node = node;
        this.uri = uri;
        this.base = base;
        if (mask != null) {
            this.pattern = Pattern.compile(mask);
        }
        this.documents = new DocumentSequence(runtime);
    }

    @Override
    public void canReadSequence(boolean sequence) {
    }

    @Override
    public boolean readSequence() {
        return false;
    }

    @Override
    public void resetReader() {
        this.pos = 0;
    }

    @Override
    public void setReader(Step step) {
        this.reader = step;
    }

    @Override
    public boolean moreDocuments() {
        if (!this.readDoc) {
            this.readDoc();
        }
        return this.pos < this.documents.size();
    }

    @Override
    public boolean closed() {
        return true;
    }

    @Override
    public int documentCount() {
        return this.documents.size();
    }

    @Override
    public DocumentSequence documents() {
        return this.documents;
    }

    @Override
    public XdmNode read() throws SaxonApiException {
        if (!this.readDoc) {
            this.readDoc();
        }
        XdmNode doc = this.documents.get(this.pos++);
        if (this.reader != null) {
            this.runtime.finest(null, this.reader.getNode(), String.valueOf(this.reader.getName()) + " select read '" + (doc == null ? "null" : doc.getBaseURI()) + "' from " + this);
        }
        return doc;
    }

    protected void readDoc() {
        block17: {
            this.readDoc = true;
            if (this.uri != null) {
                try {
                    File f;
                    String fn = this.uri;
                    if (fn.startsWith("file:") && (fn = fn.substring(5)).startsWith("///")) {
                        fn = fn.substring(2);
                    }
                    if ((f = new File(fn)).isDirectory()) {
                        if (this.pattern == null) {
                            this.pattern = Pattern.compile("^.*\\.xml$");
                        }
                        File[] fileArray = f.listFiles(new RegexFileFilter(this.pattern));
                        int n = fileArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File file = fileArray[n2];
                            XdmNode doc = this.runtime.parse(file.getCanonicalPath(), this.base);
                            this.documents.add(doc);
                            ++n2;
                        }
                        break block17;
                    }
                    XdmNode doc = null;
                    try {
                        doc = this.runtime.parse(this.uri, this.base);
                    }
                    catch (XProcException xe) {
                        if (this.runtime.transparentJSON()) {
                            try {
                                URI baseURI = new URI(this.base);
                                URL url = baseURI.resolve(this.uri).toURL();
                                URLConnection conn = url.openConnection();
                                InputStreamReader reader = new InputStreamReader(conn.getInputStream());
                                JSONTokener jt = new JSONTokener(reader);
                                doc = JSONtoXML.convert(this.runtime.getProcessor(), jt, this.runtime.jsonFlavor());
                                this.documents.add(doc);
                                return;
                            }
                            catch (Exception e) {
                                throw xe;
                            }
                        }
                        throw xe;
                    }
                    if (fn.contains("#")) {
                        XPointer xptr;
                        Vector<XdmNode> nodes;
                        int pos = fn.indexOf("#");
                        String ptr = fn.substring(pos + 1);
                        if (ptr.matches("^[\\w]+$")) {
                            ptr = "element(" + ptr + ")";
                        }
                        if ((nodes = (xptr = new XPointer(ptr)).selectNodes(this.runtime, doc)).size() == 1) {
                            doc = nodes.get(0);
                        } else if (nodes.size() != 0) {
                            throw new XProcException(this.node, "XPointer matches more than one node!?");
                        }
                    }
                    this.documents.add(doc);
                }
                catch (Exception except) {
                    throw XProcException.dynamicError(11, this.node, except, "Could not read: " + this.uri);
                }
            }
        }
    }

    private class RegexFileFilter
    implements FileFilter {
        Pattern pattern = null;

        public RegexFileFilter(Pattern p) {
            this.pattern = p;
        }

        @Override
        public boolean accept(File pathname) {
            Matcher matcher = this.pattern.matcher(pathname.getName());
            return matcher.matches();
        }
    }
}

