/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.io;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.DocumentSequence;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.util.Base64;
import com.xmlcalabash.util.HttpUtils;
import com.xmlcalabash.util.JSONtoXML;
import com.xmlcalabash.util.TreeWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Logger;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import org.json.JSONTokener;

public class ReadableData
implements ReadablePipe {
    protected String contentType = null;
    private Logger logger = Logger.getLogger(this.getClass().getName());
    public static final QName _contentType = new QName("", "content-type");
    public static final QName c_contentType = new QName("c", "http://www.w3.org/ns/xproc-step", "content-type");
    public static final QName _encoding = new QName("", "encoding");
    public static final QName c_encoding = new QName("c", "http://www.w3.org/ns/xproc-step", "encoding");
    private int pos = 0;
    private QName wrapper = null;
    private String uri = null;
    private InputStream inputStream = null;
    private String serverContentType = "content/unknown";
    private XProcRuntime runtime = null;
    private DocumentSequence documents = null;
    private Step reader = null;

    public ReadableData(XProcRuntime runtime, QName wrapper, String uri, String contentType) {
        this(runtime, wrapper, uri, null, contentType);
    }

    public ReadableData(XProcRuntime runtime, QName wrapper, InputStream inputStream, String contentType) {
        this(runtime, wrapper, null, inputStream, contentType);
    }

    private ReadableData(XProcRuntime runtime, QName wrapper, String uri, InputStream inputStream, String contentType) {
        this.runtime = runtime;
        this.uri = uri;
        this.inputStream = inputStream;
        this.wrapper = wrapper;
        this.contentType = contentType;
    }

    private DocumentSequence ensureDocuments() {
        if (this.documents != null) {
            return this.documents;
        }
        this.documents = new DocumentSequence(this.runtime);
        if (this.uri == null && this.inputStream == null) {
            return this.documents;
        }
        String userContentType = this.parseContentType(this.contentType);
        String userCharset = this.parseCharset(this.contentType);
        URI dataURI = this.uri == null ? null : this.getDataUri(this.uri);
        TreeWriter tree = new TreeWriter(this.runtime);
        tree.startDocument(dataURI);
        try {
            InputStream stream = this.uri == null ? this.inputStream : ("-".equals(this.uri) ? System.in : this.getStream(dataURI));
            String serverContentType = this.getContentType();
            if (this.contentType != null && "content/unknown".equals(serverContentType)) {
                serverContentType = this.contentType;
            }
            String serverBaseContentType = this.parseContentType(serverContentType);
            String serverCharset = this.parseCharset(serverContentType);
            if (serverCharset != null) {
                serverContentType = String.valueOf(serverBaseContentType) + "; charset=\"" + serverCharset + "\"";
            }
            String charset = serverCharset;
            if (this.uri != null && ("-".equals(this.uri) || "file".equals(dataURI.getScheme())) && serverCharset == null && serverBaseContentType.equals(userContentType)) {
                charset = userCharset;
            }
            if (this.runtime.transparentJSON() && HttpUtils.jsonContentType(this.contentType)) {
                if (charset == null) {
                    charset = "UTF-8";
                }
                InputStreamReader reader = new InputStreamReader(stream, charset);
                JSONTokener jt = new JSONTokener(reader);
                XdmNode jsonDoc = JSONtoXML.convert(this.runtime.getProcessor(), jt, this.runtime.jsonFlavor());
                tree.addSubtree(jsonDoc);
            } else {
                tree.addStartElement(this.wrapper);
                if (XProcConstants.c_data.equals(this.wrapper)) {
                    if ("content/unknown".equals(serverContentType)) {
                        tree.addAttribute(_contentType, "application/octet-stream");
                    } else {
                        tree.addAttribute(_contentType, serverContentType);
                    }
                    if (!this.isText(serverContentType, charset)) {
                        tree.addAttribute(_encoding, "base64");
                    }
                } else {
                    if ("content/unknown".equals(serverContentType)) {
                        tree.addAttribute(c_contentType, "application/octet-stream");
                    } else {
                        tree.addAttribute(c_contentType, serverContentType);
                    }
                    if (!this.isText(serverContentType, charset)) {
                        tree.addAttribute(c_encoding, "base64");
                    }
                }
                tree.startContent();
                if (this.isText(serverContentType, charset)) {
                    if (charset == null) {
                        charset = "UTF-8";
                    }
                    BufferedReader bufreader = new BufferedReader(new InputStreamReader(stream, charset));
                    int maxlen = 12288;
                    char[] chars = new char[maxlen];
                    int read = bufreader.read(chars, 0, maxlen);
                    while (read >= 0) {
                        if (read > 0) {
                            String data = new String(chars, 0, read);
                            tree.addText(data);
                        }
                        read = bufreader.read(chars, 0, maxlen);
                    }
                    bufreader.close();
                } else {
                    int maxlen = 12288;
                    byte[] bytes = new byte[maxlen];
                    int pos = 0;
                    int readlen = maxlen;
                    boolean done = false;
                    while (!done) {
                        int read = stream.read(bytes, pos, readlen);
                        if (read >= 0) {
                            pos += read;
                            readlen -= read;
                        } else {
                            done = true;
                        }
                        if (readlen != 0 && !done) continue;
                        String base64 = Base64.encodeBytes(bytes, 0, pos);
                        tree.addText(String.valueOf(base64) + "\n");
                        pos = 0;
                        readlen = maxlen;
                    }
                    stream.close();
                }
                tree.addEndElement();
            }
        }
        catch (IOException ioe) {
            throw new XProcException(XProcConstants.dynamicError(29), (Throwable)ioe);
        }
        tree.endDocument();
        this.documents.add(tree.getResult());
        return this.documents;
    }

    @Override
    public void canReadSequence(boolean sequence) {
    }

    @Override
    public boolean readSequence() {
        return false;
    }

    @Override
    public void resetReader() {
        this.pos = 0;
    }

    @Override
    public void setReader(Step step) {
        this.reader = step;
    }

    @Override
    public boolean moreDocuments() {
        DocumentSequence docs = this.ensureDocuments();
        return this.pos < docs.size();
    }

    @Override
    public boolean closed() {
        return true;
    }

    @Override
    public int documentCount() {
        DocumentSequence docs = this.ensureDocuments();
        return docs.size();
    }

    @Override
    public DocumentSequence documents() {
        return this.ensureDocuments();
    }

    @Override
    public XdmNode read() throws SaxonApiException {
        DocumentSequence docs = this.ensureDocuments();
        XdmNode doc = docs.get(this.pos++);
        if (this.reader != null) {
            this.runtime.finest(null, this.reader.getNode(), String.valueOf(this.reader.getName()) + " read '" + (doc == null ? "null" : doc.getBaseURI()) + "' from " + this);
        }
        return doc;
    }

    protected URI getDataUri(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException use) {
            throw new XProcException(use);
        }
    }

    protected InputStream getStream(URI uri) {
        try {
            URL url = uri.toURL();
            URLConnection connection = url.openConnection();
            this.serverContentType = connection.getContentType();
            this.serverContentType = this.serverContentType == null ? "content/unknown" : this.serverContentType;
            return connection.getInputStream();
        }
        catch (IOException ioe) {
            throw new XProcException(XProcConstants.dynamicError(29), (Throwable)ioe);
        }
    }

    protected String getContentType() {
        return this.serverContentType;
    }

    private boolean isText(String contentType, String charset) {
        return "application/xml".equals(contentType) || contentType.endsWith("+xml") || contentType.startsWith("text/") || "utf-8".equals(charset);
    }

    private String parseContentType(String contentType) {
        if (contentType == null) {
            return null;
        }
        int pos = contentType.indexOf(";");
        if (pos > 0) {
            String type = contentType.substring(0, pos).trim();
            return type;
        }
        return contentType;
    }

    private String parseCharset(String contentType) {
        String charset = HttpUtils.getCharset(contentType);
        if (charset != null) {
            return charset.toLowerCase();
        }
        return null;
    }
}

