/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.functions;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.functions.XProcExtensionFunctionDefinition;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class GetFilePath
extends XProcExtensionFunctionDefinition {
    private static StructuredQName funcname = new StructuredQName("es", "http://www.escali.schematron-quickfix.com/", "get-file-path");

    protected GetFilePath() {
    }

    public GetFilePath(XProcRuntime runtime) {
        this.tl_runtime.set(runtime);
    }

    @Override
    public StructuredQName getFunctionQName() {
        return funcname;
    }

    @Override
    public int getMinimumNumberOfArguments() {
        return 1;
    }

    @Override
    public int getMaximumNumberOfArguments() {
        return 1;
    }

    @Override
    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_STRING};
    }

    @Override
    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.SINGLE_STRING;
    }

    @Override
    public boolean dependsOnFocus() {
        return true;
    }

    @Override
    public ExtensionFunctionCall makeCallExpression() {
        return new ResolveURICall();
    }

    private class ResolveURICall
    extends ExtensionFunctionCall {
        private ResolveURICall() {
        }

        @Override
        public Sequence call(XPathContext xPathContext, Sequence[] sequences) throws XPathException {
            URI uri;
            String uriString = sequences[0].head().getStringValue();
            try {
                uri = new URI(uriString);
            }
            catch (URISyntaxException use) {
                throw new XProcException(use);
            }
            File file = new File(uri);
            return new StringValue(file.toString());
        }
    }
}

