/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.drivers;

import com.xmlcalabash.core.XProcConfiguration;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XPipeline;
import com.xmlcalabash.util.RelevantNodes;
import com.xmlcalabash.util.S9apiUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XdmValue;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class RunTestReport {
    public static final QName _path = new QName("path");
    public static final QName _port = new QName("port");
    public static final QName _href = new QName("href");
    public static final QName _name = new QName("name");
    public static final QName _value = new QName("value");
    public static final String NS_TEST = "http://xproc.org/ns/testsuite";
    public static final QName t_test = new QName("http://xproc.org/ns/testsuite", "test");
    public static final QName t_title = new QName("http://xproc.org/ns/testsuite", "title");
    public static final QName t_description = new QName("http://xproc.org/ns/testsuite", "description");
    public static final QName t_input = new QName("http://xproc.org/ns/testsuite", "input");
    public static final QName t_output = new QName("http://xproc.org/ns/testsuite", "output");
    public static final QName t_parameter = new QName("http://xproc.org/ns/testsuite", "parameter");
    public static final QName t_option = new QName("http://xproc.org/ns/testsuite", "option");
    public static final QName t_pipeline = new QName("http://xproc.org/ns/testsuite", "pipeline");
    public static final QName t_compare_pipeline = new QName("http://xproc.org/ns/testsuite", "compare-pipeline");
    public static final QName t_document = new QName("http://xproc.org/ns/testsuite", "document");
    private static boolean debug = false;
    private static boolean schemaAware = false;
    private static XdmNode prettyPrint = null;
    private static String defaultLog = null;
    private XProcRuntime runtime = null;

    public static void main(String[] args) throws SaxonApiException, IOException, URISyntaxException {
        String usage = "RunTests [-D] [-d directory] [-a] test.xml";
        Vector<String> tests = new Vector<String>();
        int pos = 0;
        while (pos < args.length) {
            if ("-D".equals(args[pos])) {
                debug = true;
            } else if ("-L".equals(args[pos])) {
                defaultLog = args[pos + 1];
                ++pos;
            } else if ("-a".equals(args[pos])) {
                schemaAware = true;
            } else if ("-d".equals(args[pos])) {
                int count = 0;
                File dir = new File(args[++pos]);
                String dirname = null;
                try {
                    dir = dir.getCanonicalFile();
                    dirname = dir.getName();
                }
                catch (IOException ioe) {
                    throw new XProcException(ioe);
                }
                File[] fileArray = dir.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (!file.isDirectory() && file.getName().endsWith(".xml")) {
                        ++count;
                        System.err.println("Test: " + file.getAbsolutePath());
                        tests.add(file.getAbsolutePath());
                    }
                    ++n2;
                }
                if (count == 0) {
                    System.err.println("No tests found in " + dirname);
                }
            } else {
                System.err.println("Test: " + args[pos]);
                tests.add(args[pos]);
            }
            ++pos;
        }
        if (tests.size() == 0) {
            System.err.println(usage);
            System.exit(1);
        }
        RunTestReport test = new RunTestReport();
        test.runTests(tests);
    }

    public void runTests(Vector<String> tests) {
        XProcConfiguration config = new XProcConfiguration("ee", schemaAware);
        this.runtime = new XProcRuntime(config);
        this.startReport();
        for (String testfile : tests) {
            this.run(testfile);
        }
        this.endReport();
    }

    public void run(String testfile) {
        XdmNode root;
        Vector<TestResult> results = new Vector<TestResult>();
        XProcConfiguration config = new XProcConfiguration("ee", schemaAware);
        this.runtime = new XProcRuntime(config);
        this.runtime.getConfiguration().debug = debug;
        try {
            InputStream instream = this.getClass().getResourceAsStream("/etc/prettyprint.xpl");
            if (instream == null) {
                throw new UnsupportedOperationException("Failed to load prettyprint stylesheet from resources.");
            }
            XdmNode ppd = this.runtime.parse(new InputSource(instream));
            prettyPrint = S9apiUtils.getDocumentElement(ppd);
            InputSource isource = new InputSource(testfile);
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setEntityResolver(this.runtime.getResolver());
            SAXSource source = new SAXSource(reader, isource);
            DocumentBuilder builder = this.runtime.getProcessor().newDocumentBuilder();
            builder.setLineNumbering(true);
            builder.setDTDValidation(false);
            XdmNode doc = builder.build(source);
            root = S9apiUtils.getDocumentElement(doc);
        }
        catch (Exception sae) {
            TestResult result = new TestResult(testfile);
            result.catchException(sae);
            results.add(result);
            this.makeReport(results);
            return;
        }
        if (t_test.equals(root.getNodeName())) {
            TestResult result = this.runTest(root);
            results.add(result);
            this.makeReport(results);
        } else {
            XdmNode test;
            String title = "";
            XdmSequenceIterator iter = root.axisIterator(Axis.CHILD, t_title);
            while (iter.hasNext()) {
                test = (XdmNode)iter.next();
                title = String.valueOf(title) + test.getStringValue();
            }
            iter = root.axisIterator(Axis.CHILD, t_test);
            while (iter.hasNext()) {
                test = (XdmNode)iter.next();
                TestResult result = this.runTest(test);
                results.add(result);
            }
            System.out.println("<test-suite>");
            if (!"".equals(title)) {
                System.out.println("<title>" + title + "</title>");
            }
            this.makeReport(results);
            System.out.println("</test-suite>");
        }
    }

    public TestResult runTest(XdmNode testNode) {
        if (testNode.getAttributeValue(_href) != null) {
            TestResult result;
            URI turi = testNode.getBaseURI().resolve(testNode.getAttributeValue(_href));
            try {
                InputSource isource = new InputSource(turi.toASCIIString());
                XMLReader reader = XMLReaderFactory.createXMLReader();
                reader.setEntityResolver(this.runtime.getResolver());
                SAXSource source = new SAXSource(reader, isource);
                DocumentBuilder documentBuilder = this.runtime.getProcessor().newDocumentBuilder();
                documentBuilder.setLineNumbering(true);
                documentBuilder.setDTDValidation(false);
                XdmNode doc = documentBuilder.build(source);
                XdmNode xdmNode = S9apiUtils.getDocumentElement(doc);
                result = this.runTest(xdmNode);
            }
            catch (Exception sae) {
                result = new TestResult(turi.toASCIIString());
                result.catchException(sae);
            }
            return result;
        }
        TestResult result = new TestResult(testNode.getBaseURI().toASCIIString());
        System.err.println("Running test: " + testNode.getBaseURI());
        XProcTest t = new XProcTest(testNode);
        result.setTitle(t.title);
        result.setDescription(t.description);
        if (t.pipeline == null) {
            result.catchException(new UnsupportedOperationException("Pipeline must be provided."));
            return result;
        }
        Hashtable<Object, Object> pipeoutputs = new Hashtable();
        try {
            pipeoutputs = this.runPipe(t.pipeline.pipeline, t.inputs, t.outputs, t.parameters, t.options);
        }
        catch (XProcException xprocex) {
            if (t.error == null) {
                result.fail(xprocex);
                return result;
            }
            if (xprocex.getErrorCode() != null) {
                result.catchException(xprocex);
                result.success(t.error, xprocex.getErrorCode());
                return result;
            }
            result.success(t.error, null);
            return result;
        }
        catch (Exception err) {
            result.catchException(err);
            return result;
        }
        if (t.error != null) {
            result.fail(t.error);
            return result;
        }
        if (t.comparepipeline != null) {
            XProcPipeline compare = t.comparepipeline;
            Hashtable<String, Vector<XdmNode>> cinputs = new Hashtable<String, Vector<XdmNode>>();
            for (String string : pipeoutputs.keySet()) {
                if (!compare.inputPorts.contains(string)) continue;
                ReadablePipe readablePipe = (ReadablePipe)pipeoutputs.get(string);
                while (readablePipe.moreDocuments()) {
                    try {
                        XdmNode p = readablePipe.read();
                        if (!cinputs.containsKey(string)) {
                            cinputs.put(string, new Vector());
                        }
                        cinputs.get(string).add(p);
                    }
                    catch (SaxonApiException sae) {
                        result.catchException(sae);
                        return result;
                    }
                }
            }
            try {
                pipeoutputs = this.runPipe(compare.pipeline, cinputs, t.outputs, null, null);
            }
            catch (Exception exception) {
                result.fail(exception, "Compare pipelines failed: this shouldn't happen.");
            }
        }
        Hashtable results = new Hashtable();
        Hashtable expects = new Hashtable();
        try {
            XdmNode pdoc;
            Vector pexp;
            Vector pres;
            for (String string : pipeoutputs.keySet()) {
                Vector<XdmNode> vector = t.outputs.get(string);
                ReadablePipe pipe = (ReadablePipe)pipeoutputs.get(string);
                if (!results.containsKey(string)) {
                    results.put(string, new Vector());
                }
                if (!expects.containsKey(string)) {
                    expects.put(string, new Vector());
                }
                pres = (Vector)results.get(string);
                pexp = (Vector)expects.get(string);
                while (pipe.moreDocuments()) {
                    if (vector.size() > 0) {
                        XdmNode tdoc = vector.remove(0);
                        pdoc = pipe.read();
                        if (t.ignoreWS) {
                            XPipeline pppipe = this.runtime.use(prettyPrint);
                            pppipe.writeTo("source", tdoc);
                            pppipe.run();
                            ReadablePipe rpipe = pppipe.readFrom("result");
                            tdoc = rpipe.read();
                            pppipe.reset();
                            pppipe.writeTo("source", pdoc);
                            pppipe.run();
                            rpipe = pppipe.readFrom("result");
                            pdoc = rpipe.read();
                        }
                        pres.add(pdoc);
                        pexp.add(tdoc);
                        continue;
                    }
                    XdmNode pdoc2 = pipe.read();
                    pres.add(pdoc2);
                }
            }
            QName qName = new QName("", "doca");
            QName docb = new QName("", "docb");
            for (String string : pipeoutputs.keySet()) {
                pres = (Vector)results.get(string);
                pexp = (Vector)expects.get(string);
                if (pres.size() == 0 && pexp.size() == 0) {
                    result.success();
                }
                int pos = 0;
                while (pos < pres.size() || pos < pexp.size()) {
                    XdmNode tdoc;
                    if (pos >= pres.size()) {
                        tdoc = (XdmNode)pexp.get(pos);
                        result.fail(tdoc, null);
                    } else if (pos >= pexp.size()) {
                        pdoc = (XdmNode)pres.get(pos);
                        result.fail(null, pdoc);
                    } else {
                        tdoc = (XdmNode)pexp.get(pos);
                        XdmNode pdoc3 = (XdmNode)pres.get(pos);
                        XPathCompiler xcomp = this.runtime.getProcessor().newXPathCompiler();
                        xcomp.declareVariable(qName);
                        xcomp.declareVariable(docb);
                        XPathExecutable xexec = xcomp.compile("deep-equal($doca,$docb)");
                        XPathSelector selector = xexec.load();
                        selector.setVariable(qName, tdoc);
                        selector.setVariable(docb, pdoc3);
                        Iterator<XdmItem> values = selector.iterator();
                        XdmAtomicValue item = (XdmAtomicValue)values.next();
                        boolean same = item.getBooleanValue();
                        if (same) {
                            result.success();
                        } else {
                            result.fail(tdoc, pdoc3);
                        }
                    }
                    ++pos;
                }
            }
        }
        catch (SaxonApiException saxonApiException) {
            result.fail(saxonApiException, "Error comparing results: this shouldn't happen");
        }
        if (pipeoutputs.size() == 0 && expects.size() == 0) {
            result.success();
        }
        return result;
    }

    private Hashtable<String, ReadablePipe> runPipe(XdmNode pipeline, Hashtable<String, Vector<XdmNode>> inputs, Hashtable<String, Vector<XdmNode>> outputs, Hashtable<QName, String> parameters, Hashtable<QName, String> options) throws SaxonApiException {
        XPipeline xpipeline = this.runtime.use(pipeline);
        if (inputs != null) {
            for (String port : inputs.keySet()) {
                if (!xpipeline.getInputs().contains(port)) {
                    throw new UnsupportedOperationException("Error: Test sets input port that doesn't exist: " + port);
                }
                xpipeline.clearInputs(port);
                for (XdmNode node : inputs.get(port)) {
                    xpipeline.writeTo(port, node);
                }
            }
        }
        if (parameters != null) {
            for (QName name : parameters.keySet()) {
                xpipeline.setParameter(name, new RuntimeValue(parameters.get(name)));
            }
        }
        if (options != null) {
            for (QName name : options.keySet()) {
                RuntimeValue v = _path.equals(name) ? new RuntimeValue("file:///home/ndw/tests.xproc.org/tests/required/" + options.get(name)) : new RuntimeValue(options.get(name));
                xpipeline.passOption(name, v);
            }
        }
        try {
            xpipeline.run();
        }
        catch (XProcException e) {
            if (debug) {
                e.printStackTrace();
            }
            throw e;
        }
        catch (Throwable e) {
            if (debug) {
                e.printStackTrace();
            }
            throw new XProcException(e);
        }
        Hashtable<String, ReadablePipe> pipeoutputs = new Hashtable<String, ReadablePipe>();
        Set<String> pipeouts = xpipeline.getOutputs();
        for (String port : pipeouts) {
            if (port.startsWith("!")) continue;
            ReadablePipe rpipe = xpipeline.readFrom(port);
            rpipe.canReadSequence(true);
            pipeoutputs.put(port, rpipe);
        }
        return pipeoutputs;
    }

    private void makeReport(Vector<TestResult> results) {
        for (TestResult result : results) {
            result.report();
        }
    }

    private void startReport() {
        GregorianCalendar cal = new GregorianCalendar();
        System.out.println("<test-report xmlns='http://xproc.org/ns/testreport'>");
        System.out.println("<title>XProc Test Results for XML Calabash</title>");
        System.out.print("<date>");
        System.out.print(cal.get(1));
        System.out.print("-");
        if (cal.get(2) + 1 < 10) {
            System.out.print("0");
        }
        System.out.print(cal.get(2) + 1);
        System.out.print("-");
        if (cal.get(5) < 10) {
            System.out.print("0");
        }
        System.out.print(cal.get(5));
        System.out.print("T");
        if (cal.get(11) < 10) {
            System.out.print("0");
        }
        System.out.print(cal.get(11));
        System.out.print(":");
        if (cal.get(12) < 10) {
            System.out.print("0");
        }
        System.out.print(cal.get(12));
        System.out.print(":");
        if (cal.get(13) < 10) {
            System.out.print("0");
        }
        System.out.print(cal.get(13));
        System.out.println("</date>");
        System.out.println("<processor>");
        System.out.println("<name>" + this.runtime.getProductName() + "</name>");
        System.out.println("<vendor>" + this.runtime.getVendor() + "</vendor>");
        System.out.println("<vendor-uri>" + this.runtime.getVendorURI() + "</vendor-uri>");
        System.out.println("<version>" + this.runtime.getProductVersion() + "</version>");
        System.out.println("<language>" + this.runtime.getLanguage() + "</language>");
        System.out.println("<xproc-version>" + this.runtime.getXProcVersion() + "</xproc-version>");
        System.out.println("<xpath-version>" + this.runtime.getXPathVersion() + "</xpath-version>");
        System.out.println("<psvi-supported>" + this.runtime.getPSVISupported() + "</psvi-supported>");
        System.out.println("</processor>");
    }

    private void endReport() {
        System.out.println("</test-report>");
    }

    public String serializeAsXML(XdmNode node) {
        try {
            Serializer serializer = new Serializer();
            serializer.setOutputProperty(Serializer.Property.BYTE_ORDER_MARK, "no");
            serializer.setOutputProperty(Serializer.Property.ENCODING, "utf-8");
            serializer.setOutputProperty(Serializer.Property.INDENT, "yes");
            serializer.setOutputProperty(Serializer.Property.METHOD, "xml");
            serializer.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            serializer.setOutputStream(os);
            S9apiUtils.serialize(this.runtime, node, serializer);
            String result = os.toString();
            return result;
        }
        catch (SaxonApiException sae) {
            sae.printStackTrace();
            return "";
        }
    }

    public String serialize(XdmNode node) {
        String result = this.serializeAsXML(node);
        result = result.replace("&", "&amp;");
        result = result.replace("<", "&lt;");
        result = result.replace(">", "&gt;");
        return result;
    }

    private class TestResult {
        public String testfile = null;
        public String title = "";
        public Vector<XdmNode> description = null;
        public boolean passed = false;
        public QName expectedError = null;
        public QName actualError = null;
        public Vector<String> errorMessages = new Vector();
        public XdmNode expected = null;
        public XdmNode actual = null;

        public TestResult(String testfile) {
            this.testfile = testfile;
        }

        public void setTitle(XdmNode title) {
            if (title != null) {
                this.title = title.getStringValue();
            }
        }

        public void setDescription(XdmNode desc) {
            if (desc != null) {
                XdmSequenceIterator iter = desc.axisIterator(Axis.CHILD);
                this.description = new Vector();
                while (iter.hasNext()) {
                    XdmNode node = (XdmNode)iter.next();
                    HashSet<String> prefixes = new HashSet<String>();
                    XdmSequenceIterator nsiter = node.axisIterator(Axis.NAMESPACE);
                    while (nsiter.hasNext()) {
                        XdmNode nsnode = (XdmNode)nsiter.next();
                        if (nsnode.getNodeName() == null) continue;
                        String prefix = nsnode.getNodeName().getLocalName();
                        String uri = nsnode.getStringValue();
                        if ("http://www.w3.org/1999/xhtml".equals(uri) || "xml".equals(prefix)) continue;
                        prefixes.add(uri);
                    }
                    node = S9apiUtils.removeNamespaces(RunTestReport.this.runtime, node, prefixes, true);
                    this.description.add(node);
                }
            }
        }

        public void success() {
            this.passed = true;
        }

        public void success(QName expected, QName actual) {
            this.expectedError = expected;
            this.actualError = actual;
            this.passed = true;
        }

        public void fail(QName expectedError) {
            this.errorMessages.add("Test passed, but should have raised " + expectedError);
        }

        public void fail(Exception e) {
            this.catchException(e);
        }

        public void fail(Exception e, String message) {
            this.catchException(e);
            if (message != null) {
                this.errorMessages.add(message);
            }
        }

        public void fail(XdmNode expected, XdmNode actual) {
            this.expected = expected;
            this.actual = actual;
        }

        public void report() {
            String gi = "pass";
            if (!this.passed) {
                gi = "fail";
            }
            System.out.println("<" + gi + " uri='" + this.testfile + "'>");
            if (this.title != null) {
                System.out.println("<title>" + this.title + "</title>");
            }
            if (this.actualError != null && this.expectedError == null || this.actualError == null && this.expectedError != null || this.actualError != null && this.expectedError != null && !this.actualError.equals(this.expectedError)) {
                System.out.print("<error");
                if (this.expectedError != null) {
                    System.out.print(" expected='" + this.expectedError + "'");
                }
                System.out.println(">" + this.actualError + "</error>");
            }
            for (String message : this.errorMessages) {
                System.out.println("<message>" + this.xmlEscape(message) + "</message>");
            }
            if (this.expected != null) {
                System.out.print("<expected>");
                System.out.print(RunTestReport.this.serialize(this.expected));
                System.out.println("</expected>");
            }
            if (this.actual != null) {
                System.out.print("<actual>");
                System.out.print(RunTestReport.this.serialize(this.actual));
                System.out.println("</actual>");
            }
            System.out.println("</" + gi + ">");
        }

        public void catchException(Throwable t) {
            while (t != null) {
                if (t.getMessage() != null) {
                    this.errorMessages.add(t.getMessage());
                } else {
                    this.errorMessages.add(t.toString());
                }
                if (t instanceof XProcException) {
                    XProcException xe = (XProcException)t;
                    this.actualError = xe.getErrorCode();
                    return;
                }
                t = t.getCause();
            }
        }

        private String xmlEscape(String str) {
            str = str.replaceAll("&", "&amp;");
            str = str.replaceAll("<", "&lt;");
            str = str.replaceAll(">", "&gt;");
            return str;
        }
    }

    private class XProcPipeline {
        public HashSet<String> inputPorts = new HashSet();
        public HashSet<String> outputPorts = new HashSet();
        public XdmNode pipeline = null;

        public XProcPipeline(XdmNode root) {
            this.pipeline = root;
            for (XdmNode node : new RelevantNodes(RunTestReport.this.runtime, root, Axis.CHILD)) {
                if (XProcConstants.p_input.equals(node.getNodeName())) {
                    this.inputPorts.add(node.getAttributeValue(_port));
                }
                if (!XProcConstants.p_output.equals(node.getNodeName())) continue;
                this.outputPorts.add(node.getAttributeValue(_port));
            }
        }
    }

    private class XProcTest {
        private final QName _error = new QName("error");
        private final QName _ignoreWS = new QName("ignore-whitespace-differences");
        public Hashtable<String, Vector<XdmNode>> inputs = new Hashtable();
        public Hashtable<String, Vector<XdmNode>> outputs = new Hashtable();
        public Hashtable<QName, String> parameters = new Hashtable();
        public Hashtable<QName, String> options = new Hashtable();
        public XProcPipeline pipeline = null;
        public XProcPipeline comparepipeline = null;
        public XdmNode title = null;
        public XdmNode description = null;
        public QName error = null;
        public boolean ignoreWS = false;

        public XProcTest(XdmNode root) {
            if (!t_test.equals(root.getNodeName())) {
                throw new XProcException(root, "Test must have t:test as root element.");
            }
            if (root.getAttributeValue(this._error) != null) {
                String errString = root.getAttributeValue(this._error);
                this.error = new QName(errString, root);
            }
            this.ignoreWS = true;
            if (root.getAttributeValue(this._ignoreWS) != null) {
                String ignore = root.getAttributeValue(this._ignoreWS);
                this.ignoreWS = !"false".equals(ignore);
            }
            try {
                this.scan(root);
            }
            catch (Exception e) {
                throw new XProcException(e);
            }
        }

        private void scan(XdmNode pipeline) throws SaxonApiException {
            for (XdmNode node : new RelevantNodes(RunTestReport.this.runtime, pipeline, Axis.CHILD)) {
                if (t_title.equals(node.getNodeName())) {
                    this.title = node;
                    continue;
                }
                if (t_description.equals(node.getNodeName())) {
                    this.description = node;
                    continue;
                }
                if (t_input.equals(node.getNodeName()) || t_output.equals(node.getNodeName())) {
                    this.scanio(node);
                    continue;
                }
                if (t_parameter.equals(node.getNodeName()) || t_option.equals(node.getNodeName())) {
                    this.scanop(node);
                    continue;
                }
                if (t_pipeline.equals(node.getNodeName()) || t_compare_pipeline.equals(node.getNodeName())) {
                    this.scanpipe(node);
                    continue;
                }
                throw new XProcException(pipeline, "Not a valid test: " + node.getNodeName());
            }
        }

        private void scanio(XdmNode input) throws SaxonApiException {
            String port = input.getAttributeValue(_port);
            if (port == null) {
                throw new IllegalArgumentException("Each input and output must specify a port");
            }
            if (t_output.equals(input.getNodeName()) && this.outputs.containsKey(port)) {
                throw new IllegalArgumentException("Attempt to redefine output port: " + port);
            }
            String href = input.getAttributeValue(_href);
            if (href != null) {
                this.add(input, port, href);
            } else {
                for (XdmNode node : new RelevantNodes(input, Axis.CHILD, false)) {
                    if (node.getNodeKind() != XdmNodeKind.ELEMENT) continue;
                    if (t_document.equals(node.getNodeName())) {
                        href = node.getAttributeValue(_href);
                        if (href != null) {
                            this.add(input, port, href);
                            continue;
                        }
                        Vector<XdmValue> nodes = new Vector<XdmValue>();
                        XdmSequenceIterator iter = node.axisIterator(Axis.CHILD);
                        while (iter.hasNext()) {
                            nodes.add(iter.next());
                        }
                        XdmDestination dest = new XdmDestination();
                        S9apiUtils.writeXdmValue(RunTestReport.this.runtime, nodes, (Destination)dest, node.getBaseURI());
                        this.add(input, port, dest.getXdmNode());
                        continue;
                    }
                    XdmDestination dest = new XdmDestination();
                    S9apiUtils.writeXdmValue(RunTestReport.this.runtime, node, (Destination)dest, node.getBaseURI());
                    XdmNode newNode = dest.getXdmNode();
                    this.add(input, port, dest.getXdmNode());
                }
            }
        }

        private void scanpipe(XdmNode input) throws SaxonApiException {
            URI baseURI = input.getBaseURI();
            String href = input.getAttributeValue(_href);
            if (href != null) {
                this.add(input, null, baseURI.resolve(href).toASCIIString());
            } else {
                XdmNode docroot = null;
                for (XdmNode node : new RelevantNodes(input, Axis.CHILD, true)) {
                    if (node.getNodeKind() != XdmNodeKind.ELEMENT) continue;
                    docroot = node;
                }
                if (t_document.equals(docroot.getNodeName())) {
                    href = docroot.getAttributeValue(_href);
                    if (href != null) {
                        this.add(input, null, docroot.getBaseURI().resolve(href).toASCIIString());
                    } else {
                        XdmNode root = S9apiUtils.getDocumentElement(docroot);
                        this.add(input, null, root);
                    }
                } else {
                    this.add(input, null, docroot);
                }
            }
        }

        private void scanop(XdmNode input) {
            String namestr = input.getAttributeValue(_name);
            String value = input.getAttributeValue(_value);
            if (namestr == null || value == null) {
                throw new IllegalArgumentException("Each option and parameter must specify a name and a value");
            }
            QName name = new QName(namestr, input);
            if (t_option.equals(input.getNodeName())) {
                if (this.options.containsKey(name)) {
                    throw new IllegalArgumentException("Attempt to redefine option: " + name);
                }
                this.options.put(name, value);
            } else {
                if (this.parameters.containsKey(name)) {
                    throw new IllegalArgumentException("Attempt to redefine parameter: " + name);
                }
                this.parameters.put(name, value);
            }
            Iterator<XdmNode> iterator = new RelevantNodes(RunTestReport.this.runtime, input, Axis.CHILD).iterator();
            if (iterator.hasNext()) {
                XdmNode node = iterator.next();
                throw new IllegalArgumentException("Options and parameters must be empty.");
            }
        }

        private void add(XdmNode node, String port, String href) throws SaxonApiException {
            String rhref = node.getBaseURI().resolve(href).toASCIIString();
            this.add(node, port, RunTestReport.this.runtime.parse(new InputSource(rhref)));
        }

        private void add(XdmNode node, String port, XdmNode root) {
            String type = node.getNodeName().getLocalName();
            if ("input".equals(type)) {
                if (!this.inputs.containsKey(port)) {
                    this.inputs.put(port, new Vector());
                }
                this.inputs.get(port).add(root);
            } else if ("output".equals(type)) {
                if (!this.outputs.containsKey(port)) {
                    this.outputs.put(port, new Vector());
                }
                this.outputs.get(port).add(root);
            } else if ("pipeline".equals(type)) {
                if (this.pipeline != null) {
                    throw new UnsupportedOperationException("Only one pipeline can be defined.");
                }
                this.pipeline = new XProcPipeline(root);
            } else if ("compare-pipeline".equals(type)) {
                if (this.comparepipeline != null) {
                    throw new UnsupportedOperationException("Only one compare pipeline can be defined.");
                }
                this.comparepipeline = new XProcPipeline(root);
            } else {
                throw new UnsupportedOperationException("Unexpected type: " + type);
            }
        }
    }
}

