/*
 * Decompiled with CFR 0.152.
 */
package net.sqf.xmlUtils.xpath;

import com.ctc.wstx.cfg.ErrorConsts;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NamespaceContextImpl
implements NamespaceContext {
    private HashMap<String, String> uriByPrefix = new HashMap();
    private HashMap<String, String> prefixByUri = new HashMap();
    private ArrayList<String> allPrefies = new ArrayList();

    public NamespaceContextImpl(Element el) {
        Node parent = el.getParentNode();
        Object parentNSC = parent.getUserData("namespaceContext");
        Object childNSC = el.getUserData("namespaceContext");
        if (parentNSC != null) {
            this.addAllNs((NamespaceContextImpl)parentNSC);
        }
        if (childNSC != null) {
            this.addAllNs((NamespaceContextImpl)childNSC);
        }
    }

    public NamespaceContextImpl(XMLStreamReader event) {
        int i = 0;
        while (i < event.getNamespaceCount()) {
            String uri = event.getNamespaceURI(i);
            String pre = event.getNamespacePrefix(i);
            this.addNS(pre, uri);
            ++i;
        }
    }

    private void addAllNs(NamespaceContextImpl nsc) {
        for (String pre : nsc.allPrefies) {
            String uri = nsc.getNamespaceURI(pre);
            this.addNS(pre, uri);
        }
    }

    private void addNS(String pre, String uri) {
        this.uriByPrefix.put(pre, uri);
        this.prefixByUri.put(uri, pre);
        this.allPrefies.add(pre);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException(ErrorConsts.ERR_NULL_ARG);
        }
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (prefix.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        return this.uriByPrefix.get(prefix);
    }

    @Override
    public String getPrefix(String uri) {
        if (uri == null || uri.length() == 0) {
            throw new IllegalArgumentException("Illegal to pass null/empty prefix as argument.");
        }
        if (uri.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        if (uri.equals("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        return this.prefixByUri.get(uri);
    }

    @Override
    public Iterator getPrefixes(String arg0) {
        return null;
    }

    public ArrayList<String> getAllPrefixes() {
        return this.allPrefies;
    }
}

