/*
 * Decompiled with CFR 0.152.
 */
package net.sqf.xmlUtils.staxParser;

import javax.xml.stream.Location;
import net.sqf.xmlUtils.staxParser.PositionalXMLReader;
import org.w3c.dom.Node;

public class NodeInfo {
    private final Node node;
    private final Location start;
    private final Location end;

    protected NodeInfo(Node node) {
        this.node = node;
        this.start = PositionalXMLReader.getLocation(node, "nodeLocationStart");
        this.end = PositionalXMLReader.getLocation(node, "nodeLocationEnd");
    }

    public Node getNode() {
        return this.node;
    }

    public Location getStart() {
        return this.start;
    }

    public int getStartOffset() {
        return this.start.getCharacterOffset();
    }

    public Location getEnd() {
        return this.end;
    }

    public int getEndOffset() {
        return this.end.getCharacterOffset();
    }

    public int getLength() {
        return this.getEndOffset() - this.getStartOffset();
    }

    public int getMarkStart() {
        return this.getStartOffset();
    }

    public int getMarkEnd() {
        return this.getEndOffset();
    }

    public String toString() {
        return String.valueOf(this.node.toString()) + ": [start:" + this.getStartOffset() + "; end:" + this.getEndOffset() + "]";
    }
}

