/*
 * Decompiled with CFR 0.152.
 */
package net.sqf.utils.process.queues2;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.SwingWorker;
import net.sqf.utils.process.queues2.listeners.QueueListener;

public abstract class Task<IOType>
extends SwingWorker<IOType, IOType>
implements PropertyChangeListener {
    private final String description;
    private IOType input = null;
    private ArrayList<QueueListener<IOType>> startListener = new ArrayList();
    private ArrayList<QueueListener<IOType>> endListener = new ArrayList();
    private final ArrayList<QueueListener<IOType>> cancelListener = new ArrayList();

    public Task(String description) {
        this.description = description;
        this.addPropertyChangeListener(this);
    }

    public void start(IOType input) {
        this.input = input;
        this.processStartListener();
        this.execute();
    }

    @Override
    protected IOType doInBackground() throws Exception {
        try {
            IOType output = this.process(this.input);
            this.setProgress(100);
            return output;
        }
        catch (Exception e) {
            this.cancel(e);
            throw e;
        }
    }

    @Override
    protected void done() {
        super.done();
    }

    public abstract IOType process(IOType var1) throws Exception;

    public boolean isFinished() {
        return this.getState().equals((Object)SwingWorker.StateValue.DONE);
    }

    public String toString() {
        return this.description;
    }

    protected void cancel(Exception e) {
        for (QueueListener<IOType> lis : this.cancelListener) {
            lis.processCancel(this, e);
        }
        this.cancel(true);
    }

    public void addCancelListener(QueueListener<IOType> listener) {
        this.cancelListener.add(listener);
    }

    public void addEndListener(QueueListener<IOType> listener) {
        this.endListener.add(listener);
    }

    private void processEndListener() {
        for (QueueListener<IOType> lis : this.endListener) {
            lis.processEnd(this);
        }
    }

    public void addStartListener(QueueListener<IOType> listener) {
        this.startListener.add(listener);
    }

    private void processStartListener() {
        for (QueueListener<IOType> lis : this.startListener) {
            lis.processStart(this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("state".equals(evt.getPropertyName()) && SwingWorker.StateValue.DONE == evt.getNewValue()) {
            this.processEndListener();
        }
    }
}

