/*
 * Decompiled with CFR 0.152.
 */
package net.sqf.utils.process.queues;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import net.sqf.utils.process.queues.SimpleTask;
import net.sqf.utils.process.queues.WatchTask;

class Watcher
extends SimpleTask<Void, Void> {
    private final ArrayList<WatchTask> tasks = new ArrayList();
    private int intervall;
    public int counter = 0;
    private boolean isProcessing = true;

    protected Watcher(String title, double intervallInSec) {
        super(title, Void.class, Void.class);
        this.setInterval(intervallInSec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void process(Void Input) throws Exception {
        while (this.isProcessing) {
            ArrayList<WatchTask> arrayList = this.tasks;
            synchronized (arrayList) {
                try {
                    for (WatchTask task : this.tasks) {
                        task.watch();
                    }
                }
                catch (ConcurrentModificationException e) {
                    System.err.println("catched concurrent modification exception!");
                }
                ++this.counter;
            }
            Thread.sleep(this.intervall);
        }
        return null;
    }

    public void cancel() {
        this.isProcessing = false;
    }

    public void setInterval(double intervallInSec) {
        this.intervall = (int)(intervallInSec * 1000.0);
    }

    public void addTask(WatchTask task) {
        this.tasks.add(task);
    }
}

